/*
 * Decompiled with CFR 0.152.
 */
package de.schlund.pfixcore.example;

import de.schlund.pfixcore.example.ContextAdultInfo;
import de.schlund.pfixcore.example.ContextTrouser;
import de.schlund.pfixcore.example.StatusCodeLib;
import de.schlund.pfixcore.example.iwrapper.Trouser;
import java.util.Arrays;
import java.util.HashSet;
import org.pustefixframework.web.mvc.InputHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class TrouserHandler
implements InputHandler<Trouser> {
    private ContextAdultInfo cai;
    private ContextTrouser ct;

    public void handleSubmittedData(Trouser trouser) {
        HashSet<Integer> set;
        Integer color = trouser.getColor();
        String size = trouser.getSize();
        Integer[] feature = trouser.getFeature();
        if (feature != null && color.equals(new Integer(2)) && (set = new HashSet<Integer>(Arrays.asList(feature))).contains(new Integer(1))) {
            String[] args = new String[]{"1", "2"};
            trouser.addSCodeColor(StatusCodeLib.TROUSER_FEATURECOLOR_OUTOF_STOCK, args, null);
            return;
        }
        this.ct.setSize(size);
        this.ct.setFeature(feature);
        this.ct.setColor(color);
    }

    public void retrieveCurrentStatus(Trouser trouser) {
        if (!this.ct.needsData()) {
            trouser.setColor(this.ct.getColor());
            trouser.setSize(this.ct.getSize());
            trouser.setFeature(this.ct.getFeature());
        }
    }

    public boolean needsData() {
        return this.ct.needsData();
    }

    public boolean prerequisitesMet() {
        return !this.cai.needsData();
    }

    public boolean isActive() {
        Boolean adult = this.cai.getAdult();
        if (adult != null) {
            if (!adult.booleanValue()) {
                this.ct.reset();
            }
            return adult;
        }
        return false;
    }

    @Autowired
    public void setContextTrouser(ContextTrouser ct) {
        this.ct = ct;
    }

    @Autowired
    public void setContextAdultInfo(ContextAdultInfo cai) {
        this.cai = cai;
    }
}

