/*
 * Decompiled with CFR 0.152.
 */
package de.schlund.pfixcore.example.iwrapper;

import de.schlund.pfixcore.example.TestChecksHandler;
import de.schlund.pfixcore.generator.IWrapperImpl;
import de.schlund.pfixcore.generator.IWrapperParam;
import de.schlund.pfixcore.generator.IWrapperParamCaster;
import de.schlund.pfixcore.generator.IWrapperParamPostCheck;
import de.schlund.pfixcore.generator.IWrapperParamPreCheck;
import de.schlund.pfixcore.generator.UseHandlerClass;
import de.schlund.pfixcore.generator.annotation.Caster;
import de.schlund.pfixcore.generator.annotation.PostCheck;
import de.schlund.pfixcore.generator.annotation.PreCheck;
import de.schlund.pfixcore.generator.annotation.Property;
import de.schlund.pfixcore.generator.casters.ToBoolean;
import de.schlund.pfixcore.generator.casters.ToByte;
import de.schlund.pfixcore.generator.casters.ToDate;
import de.schlund.pfixcore.generator.casters.ToDouble;
import de.schlund.pfixcore.generator.casters.ToFile;
import de.schlund.pfixcore.generator.casters.ToFloat;
import de.schlund.pfixcore.generator.casters.ToInteger;
import de.schlund.pfixcore.generator.casters.ToLong;
import de.schlund.pfixcore.generator.casters.ToUploadFile;
import de.schlund.pfixcore.generator.postchecks.FloatRange;
import de.schlund.pfixcore.generator.postchecks.IntegerRange;
import de.schlund.pfixcore.generator.postchecks.StringLength;
import de.schlund.pfixcore.generator.prechecks.RegexpCheck;
import de.schlund.pfixxml.multipart.UploadFile;
import de.schlund.util.statuscodes.StatusCode;
import java.io.File;
import java.util.Date;

@UseHandlerClass(value=TestChecksHandler.class)
public class TestChecks
extends IWrapperImpl {
    protected synchronized void registerParams() {
        StringLength post;
        ToDate caster;
        IWrapperParam pinfo;
        if (!this.params.containsKey("Date")) {
            pinfo = new IWrapperParam("Date", false, true, null, "java.util.Date", true);
            this.params.put("Date", pinfo);
            caster = new ToDate();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            caster.setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.DATE_ERR");
            caster.setFormat("yy/MM/dd");
            caster.setParamFormat("yy/MM/dd");
        }
        if (!this.params.containsKey("Integer")) {
            pinfo = new IWrapperParam("Integer", false, true, null, "java.lang.Integer", true);
            this.params.put("Integer", pinfo);
            caster = new ToInteger();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            ((ToInteger)caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.INT_ERR");
        }
        if (!this.params.containsKey("Boolean")) {
            pinfo = new IWrapperParam("Boolean", false, true, null, "java.lang.Boolean", true);
            this.params.put("Boolean", pinfo);
            caster = new ToBoolean();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            ((ToBoolean)caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.BOOL_ERR");
        }
        if (!this.params.containsKey("Byte")) {
            pinfo = new IWrapperParam("Byte", false, true, null, "java.lang.Byte", true);
            this.params.put("Byte", pinfo);
            caster = new ToByte();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            ((ToByte)caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.BYTE_ERR");
        }
        if (!this.params.containsKey("Long")) {
            pinfo = new IWrapperParam("Long", false, true, null, "java.lang.Long", true);
            this.params.put("Long", pinfo);
            caster = new ToLong();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            ((ToLong)caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.LONG_ERR");
        }
        if (!this.params.containsKey("Float")) {
            pinfo = new IWrapperParam("Float", false, true, null, "java.lang.Float", true);
            this.params.put("Float", pinfo);
            caster = new ToFloat();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            ((ToFloat)caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_ERR");
        }
        if (!this.params.containsKey("Double")) {
            pinfo = new IWrapperParam("Double", false, true, null, "java.lang.Double", true);
            this.params.put("Double", pinfo);
            caster = new ToDouble();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            ((ToDouble)caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.DOUBLE_ERR");
        }
        if (!this.params.containsKey("FloatRange")) {
            pinfo = new IWrapperParam("FloatRange", false, true, null, "java.lang.Float", true);
            this.params.put("FloatRange", pinfo);
            caster = new ToFloat();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            ((ToFloat)caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_ERR");
            post = new FloatRange();
            pinfo.addPostChecker((IWrapperParamPostCheck)post);
            ((FloatRange)post).setRange("1.1:2.5");
            ((FloatRange)post).setScodeTooSmall("de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_TOO_SMALL");
            ((FloatRange)post).setScodeTooBig("de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_TOO_BIG");
        }
        if (!this.params.containsKey("IntegerRange")) {
            pinfo = new IWrapperParam("IntegerRange", false, true, null, "java.lang.Integer", true);
            this.params.put("IntegerRange", pinfo);
            caster = new ToInteger();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            ((ToInteger)caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.INT_ERR");
            post = new IntegerRange();
            pinfo.addPostChecker((IWrapperParamPostCheck)post);
            ((IntegerRange)post).setRange("10:20");
            ((IntegerRange)post).setScodeTooSmall("de.schlund.pfixcore.example.StatusCodeLib#checks.INT_TOO_SMALL");
            ((IntegerRange)post).setScodeTooBig("de.schlund.pfixcore.example.StatusCodeLib#checks.INT_TOO_BIG");
        }
        if (!this.params.containsKey("StringLength")) {
            pinfo = new IWrapperParam("StringLength", false, true, null, "java.lang.String", true);
            this.params.put("StringLength", pinfo);
            post = new StringLength();
            pinfo.addPostChecker((IWrapperParamPostCheck)post);
            post.setMinLength("2");
            post.setMaxLength("10");
            post.setScodeTooShort("de.schlund.pfixcore.example.StatusCodeLib#checks.STRING_TOO_SHORT");
            post.setScodeTooLong("de.schlund.pfixcore.example.StatusCodeLib#checks.STRING_TOO_LONG");
        }
        if (!this.params.containsKey("RegExp")) {
            pinfo = new IWrapperParam("RegExp", false, true, null, "java.lang.String", true);
            this.params.put("RegExp", pinfo);
            RegexpCheck pre = new RegexpCheck();
            pinfo.addPreChecker((IWrapperParamPreCheck)pre);
            pre.setRegexp("/^[a-zA-Z]*$/");
            pre.setScodeNoMatch("de.schlund.pfixcore.example.StatusCodeLib#checks.REGEXP_NO_MATCH");
        }
        if (!this.params.containsKey("File")) {
            pinfo = new IWrapperParam("File", false, true, null, "java.io.File", true);
            this.params.put("File", pinfo);
            caster = new ToFile();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            ((ToFile)caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.FILE_ERR");
        }
        if (!this.params.containsKey("UploadFile")) {
            pinfo = new IWrapperParam("UploadFile", false, true, null, "de.schlund.pfixxml.multipart.UploadFile", true);
            this.params.put("UploadFile", pinfo);
            caster = new ToUploadFile();
            pinfo.setParamCaster((IWrapperParamCaster)caster);
            ((ToUploadFile)caster).setScodeCastError("de.schlund.pfixcore.example.StatusCodeLib#checks.UPLOAD_FILE_ERR");
        }
        super.registerParams();
    }

    @Caster(type=ToDate.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.DATE_ERR"), @Property(name="format", value="yy/MM/dd"), @Property(name="paramFormat", value="yy/MM/dd")})
    public Date getDate() {
        return (Date)this.gimmeParamForKey("Date").getValue();
    }

    public void setStringValDate(String v) {
        this.gimmeParamForKey("Date").setStringValue((Object[])new String[]{v});
    }

    public void setDate(Date v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("Date");
        this.setStringValue((Object[])new Date[]{v}, iwrpParam);
    }

    public void addSCodeDate(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("Date"), scode, null, null);
    }

    public void addSCodeDate(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("Date"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsDate(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("Date"), scode, args, null);
    }

    @Caster(type=ToInteger.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.INT_ERR")})
    public Integer getInteger() {
        return (Integer)this.gimmeParamForKey("Integer").getValue();
    }

    public void setStringValInteger(String v) {
        this.gimmeParamForKey("Integer").setStringValue((Object[])new String[]{v});
    }

    public void setInteger(Integer v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("Integer");
        this.setStringValue((Object[])new Integer[]{v}, iwrpParam);
    }

    public void addSCodeInteger(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("Integer"), scode, null, null);
    }

    public void addSCodeInteger(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("Integer"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsInteger(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("Integer"), scode, args, null);
    }

    @Caster(type=ToBoolean.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.BOOL_ERR")})
    public Boolean getBoolean() {
        return (Boolean)this.gimmeParamForKey("Boolean").getValue();
    }

    public void setStringValBoolean(String v) {
        this.gimmeParamForKey("Boolean").setStringValue((Object[])new String[]{v});
    }

    public void setBoolean(Boolean v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("Boolean");
        this.setStringValue((Object[])new Boolean[]{v}, iwrpParam);
    }

    public void addSCodeBoolean(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("Boolean"), scode, null, null);
    }

    public void addSCodeBoolean(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("Boolean"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsBoolean(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("Boolean"), scode, args, null);
    }

    @Caster(type=ToByte.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.BYTE_ERR")})
    public Byte getByte() {
        return (Byte)this.gimmeParamForKey("Byte").getValue();
    }

    public void setStringValByte(String v) {
        this.gimmeParamForKey("Byte").setStringValue((Object[])new String[]{v});
    }

    public void setByte(Byte v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("Byte");
        this.setStringValue((Object[])new Byte[]{v}, iwrpParam);
    }

    public void addSCodeByte(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("Byte"), scode, null, null);
    }

    public void addSCodeByte(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("Byte"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsByte(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("Byte"), scode, args, null);
    }

    @Caster(type=ToLong.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.LONG_ERR")})
    public Long getLong() {
        return (Long)this.gimmeParamForKey("Long").getValue();
    }

    public void setStringValLong(String v) {
        this.gimmeParamForKey("Long").setStringValue((Object[])new String[]{v});
    }

    public void setLong(Long v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("Long");
        this.setStringValue((Object[])new Long[]{v}, iwrpParam);
    }

    public void addSCodeLong(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("Long"), scode, null, null);
    }

    public void addSCodeLong(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("Long"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsLong(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("Long"), scode, args, null);
    }

    @Caster(type=ToFloat.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_ERR")})
    public Float getFloat() {
        return (Float)this.gimmeParamForKey("Float").getValue();
    }

    public void setStringValFloat(String v) {
        this.gimmeParamForKey("Float").setStringValue((Object[])new String[]{v});
    }

    public void setFloat(Float v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("Float");
        this.setStringValue((Object[])new Float[]{v}, iwrpParam);
    }

    public void addSCodeFloat(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("Float"), scode, null, null);
    }

    public void addSCodeFloat(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("Float"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsFloat(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("Float"), scode, args, null);
    }

    @Caster(type=ToDouble.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.DOUBLE_ERR")})
    public Double getDouble() {
        return (Double)this.gimmeParamForKey("Double").getValue();
    }

    public void setStringValDouble(String v) {
        this.gimmeParamForKey("Double").setStringValue((Object[])new String[]{v});
    }

    public void setDouble(Double v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("Double");
        this.setStringValue((Object[])new Double[]{v}, iwrpParam);
    }

    public void addSCodeDouble(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("Double"), scode, null, null);
    }

    public void addSCodeDouble(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("Double"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsDouble(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("Double"), scode, args, null);
    }

    @Caster(type=ToFloat.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_ERR")})
    @PostCheck(type=FloatRange.class, properties={@Property(name="range", value="1.1:2.5"), @Property(name="scodeTooSmall", value="de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_TOO_SMALL"), @Property(name="scodeTooBig", value="de.schlund.pfixcore.example.StatusCodeLib#checks.FLOAT_TOO_BIG")})
    public Float getFloatRange() {
        return (Float)this.gimmeParamForKey("FloatRange").getValue();
    }

    public void setStringValFloatRange(String v) {
        this.gimmeParamForKey("FloatRange").setStringValue((Object[])new String[]{v});
    }

    public void setFloatRange(Float v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("FloatRange");
        this.setStringValue((Object[])new Float[]{v}, iwrpParam);
    }

    public void addSCodeFloatRange(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("FloatRange"), scode, null, null);
    }

    public void addSCodeFloatRange(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("FloatRange"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsFloatRange(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("FloatRange"), scode, args, null);
    }

    @Caster(type=ToInteger.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.INT_ERR")})
    @PostCheck(type=IntegerRange.class, properties={@Property(name="range", value="10:20"), @Property(name="scodeTooSmall", value="de.schlund.pfixcore.example.StatusCodeLib#checks.INT_TOO_SMALL"), @Property(name="scodeTooBig", value="de.schlund.pfixcore.example.StatusCodeLib#checks.INT_TOO_BIG")})
    public Integer getIntegerRange() {
        return (Integer)this.gimmeParamForKey("IntegerRange").getValue();
    }

    public void setStringValIntegerRange(String v) {
        this.gimmeParamForKey("IntegerRange").setStringValue((Object[])new String[]{v});
    }

    public void setIntegerRange(Integer v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("IntegerRange");
        this.setStringValue((Object[])new Integer[]{v}, iwrpParam);
    }

    public void addSCodeIntegerRange(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("IntegerRange"), scode, null, null);
    }

    public void addSCodeIntegerRange(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("IntegerRange"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsIntegerRange(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("IntegerRange"), scode, args, null);
    }

    @PostCheck(type=StringLength.class, properties={@Property(name="minLength", value="2"), @Property(name="maxLength", value="10"), @Property(name="scodeTooShort", value="de.schlund.pfixcore.example.StatusCodeLib#checks.STRING_TOO_SHORT"), @Property(name="scodeTooLong", value="de.schlund.pfixcore.example.StatusCodeLib#checks.STRING_TOO_LONG")})
    public String getStringLength() {
        return (String)this.gimmeParamForKey("StringLength").getValue();
    }

    public void setStringValStringLength(String v) {
        this.gimmeParamForKey("StringLength").setStringValue((Object[])new String[]{v});
    }

    public void setStringLength(String v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("StringLength");
        this.setStringValue((Object[])new String[]{v}, iwrpParam);
    }

    public void addSCodeStringLength(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("StringLength"), scode, null, null);
    }

    public void addSCodeStringLength(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("StringLength"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsStringLength(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("StringLength"), scode, args, null);
    }

    @PreCheck(type=RegexpCheck.class, properties={@Property(name="regexp", value="/^[a-zA-Z]*$/"), @Property(name="scodeNoMatch", value="de.schlund.pfixcore.example.StatusCodeLib#checks.REGEXP_NO_MATCH")})
    public String getRegExp() {
        return (String)this.gimmeParamForKey("RegExp").getValue();
    }

    public void setStringValRegExp(String v) {
        this.gimmeParamForKey("RegExp").setStringValue((Object[])new String[]{v});
    }

    public void setRegExp(String v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("RegExp");
        this.setStringValue((Object[])new String[]{v}, iwrpParam);
    }

    public void addSCodeRegExp(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("RegExp"), scode, null, null);
    }

    public void addSCodeRegExp(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("RegExp"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsRegExp(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("RegExp"), scode, args, null);
    }

    @Caster(type=ToFile.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.FILE_ERR")})
    public File getFile() {
        return (File)this.gimmeParamForKey("File").getValue();
    }

    public void setStringValFile(String v) {
        this.gimmeParamForKey("File").setStringValue((Object[])new String[]{v});
    }

    public void setFile(File v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("File");
        this.setStringValue((Object[])new File[]{v}, iwrpParam);
    }

    public void addSCodeFile(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("File"), scode, null, null);
    }

    public void addSCodeFile(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("File"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsFile(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("File"), scode, args, null);
    }

    @Caster(type=ToUploadFile.class, properties={@Property(name="scodeCastError", value="de.schlund.pfixcore.example.StatusCodeLib#checks.UPLOAD_FILE_ERR")})
    public UploadFile getUploadFile() {
        return (UploadFile)this.gimmeParamForKey("UploadFile").getValue();
    }

    public void setStringValUploadFile(String v) {
        this.gimmeParamForKey("UploadFile").setStringValue((Object[])new String[]{v});
    }

    public void setUploadFile(UploadFile v) {
        IWrapperParam iwrpParam = this.gimmeParamForKey("UploadFile");
        this.setStringValue((Object[])new UploadFile[]{v}, iwrpParam);
    }

    public void addSCodeUploadFile(StatusCode scode) {
        this.addSCode(this.gimmeParamForKey("UploadFile"), scode, null, null);
    }

    public void addSCodeUploadFile(StatusCode scode, String[] args, String level) {
        this.addSCode(this.gimmeParamForKey("UploadFile"), scode, args, level);
    }

    @Deprecated
    public void addSCodeWithArgsUploadFile(StatusCode scode, String[] args) {
        this.addSCode(this.gimmeParamForKey("UploadFile"), scode, args, null);
    }
}

