/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree.
 */

package org.pytorch.executorch.annotations;

/**
 * This annotation indicates that an API is experimental and may change or be removed at any time.
 * It does not provide any guarantees for API stability or backward-compatibility.
 *
 * <p>This status is not permanent, and APIs marked with this annotation will need to be either made
 * more robust or removed in the future.
 */
public @interface Experimental {}
