/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.executorch.extension.llm;

import com.facebook.jni.HybridData;
import com.facebook.jni.annotations.DoNotStrip;
import com.facebook.soloader.nativeloader.NativeLoader;
import com.facebook.soloader.nativeloader.NativeLoaderDelegate;
import com.facebook.soloader.nativeloader.SystemDelegate;
import org.pytorch.executorch.annotations.Experimental;
import org.pytorch.executorch.extension.llm.LlmCallback;

@Experimental
public class LlmModule {
    public static final int MODEL_TYPE_TEXT = 1;
    public static final int MODEL_TYPE_TEXT_VISION = 2;
    private final HybridData mHybridData;
    private static final int DEFAULT_SEQ_LEN = 128;
    private static final boolean DEFAULT_ECHO = true;

    @DoNotStrip
    private static native HybridData initHybrid(int var0, String var1, String var2, float var3, String var4);

    public LlmModule(String modulePath, String tokenizerPath, float temperature) {
        this.mHybridData = LlmModule.initHybrid(1, modulePath, tokenizerPath, temperature, null);
    }

    public LlmModule(String modulePath, String tokenizerPath, float temperature, String dataPath) {
        this.mHybridData = LlmModule.initHybrid(1, modulePath, tokenizerPath, temperature, dataPath);
    }

    public LlmModule(int modelType, String modulePath, String tokenizerPath, float temperature) {
        this.mHybridData = LlmModule.initHybrid(modelType, modulePath, tokenizerPath, temperature, null);
    }

    public void resetNative() {
        this.mHybridData.resetNative();
    }

    public int generate(String prompt, LlmCallback llmCallback) {
        return this.generate(prompt, 128, llmCallback, true);
    }

    public int generate(String prompt, int seqLen, LlmCallback llmCallback) {
        return this.generate(null, 0, 0, 0, prompt, seqLen, llmCallback, true);
    }

    public int generate(String prompt, LlmCallback llmCallback, boolean echo) {
        return this.generate(null, 0, 0, 0, prompt, 128, llmCallback, echo);
    }

    public int generate(String prompt, int seqLen, LlmCallback llmCallback, boolean echo) {
        return this.generate(null, 0, 0, 0, prompt, seqLen, llmCallback, echo);
    }

    @DoNotStrip
    public native int generate(int[] var1, int var2, int var3, int var4, String var5, int var6, LlmCallback var7, boolean var8);

    public long prefillImages(int[] image, int width, int height, int channels, long startPos) {
        long[] nativeResult = this.prefillImagesNative(image, width, height, channels, startPos);
        if (nativeResult[0] != 0L) {
            throw new RuntimeException("Prefill failed with error code: " + nativeResult[0]);
        }
        return nativeResult[1];
    }

    private native long[] prefillImagesNative(int[] var1, int var2, int var3, int var4, long var5);

    public long prefillPrompt(String prompt, long startPos, int bos, int eos) {
        long[] nativeResult = this.prefillPromptNative(prompt, startPos, bos, eos);
        if (nativeResult[0] != 0L) {
            throw new RuntimeException("Prefill failed with error code: " + nativeResult[0]);
        }
        return nativeResult[1];
    }

    private native long[] prefillPromptNative(String var1, long var2, int var4, int var5);

    public native int generateFromPos(String var1, int var2, long var3, LlmCallback var5, boolean var6);

    @DoNotStrip
    public native void stop();

    @DoNotStrip
    public native int load();

    static {
        if (!NativeLoader.isInitialized()) {
            NativeLoader.init((NativeLoaderDelegate)new SystemDelegate());
        }
        NativeLoader.loadLibrary((String)"executorch");
    }
}

