/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.context;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.qbicc.context.Location;

public final class Diagnostic {
    private final Diagnostic parent;
    private final Level level;
    private final String format;
    private final Object[] args;
    private final Location location;
    private final List<Diagnostic> children = new ArrayList<Diagnostic>(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Diagnostic(Diagnostic parent, Location location, Level level, String format, Object ... args) {
        Assert.checkNotNullParam((String)"location", (Object)location);
        this.parent = parent;
        this.level = level;
        this.format = format;
        this.args = args;
        this.location = location;
        if (parent != null) {
            List<Diagnostic> list = parent.children;
            synchronized (list) {
                parent.children.add(this);
            }
        }
    }

    public Diagnostic getParent() {
        return this.parent;
    }

    public Level getLevel() {
        return this.level;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getFormatted() {
        return String.format(this.format, this.args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Diagnostic> getChildren() {
        List<Diagnostic> list = this.children;
        synchronized (list) {
            return this.children.isEmpty() ? List.of() : List.copyOf(this.children);
        }
    }

    public void appendTo(Appendable output) throws IOException {
        if (output instanceof StringBuilder) {
            this.appendTo((StringBuilder)output);
        } else {
            output.append(this.appendTo(new StringBuilder()));
        }
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (this.location.hasLocation()) {
            this.location.appendBaseString(builder);
            builder.append(": ");
        }
        builder.append((Object)this.level).append(": ");
        builder.append(this.getFormatted());
        builder.append('\n');
        if (this.location.hasMemberName()) {
            builder.append("    ");
            this.location.appendMemberString(builder);
            builder.append('\n');
        }
        if (this.location.hasClassName()) {
            builder.append("  ");
            this.location.appendLocationString(builder);
            builder.append('\n');
        }
        for (Diagnostic child : this.getChildren()) {
            child.appendTo(builder);
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public static enum Level {
        ERROR("error"),
        WARNING("warning"),
        NOTE("note"),
        INFO("info"),
        DEBUG("debug");

        private final String str;

        private Level(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

