/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.context;

import java.util.function.Function;
import java.util.function.Supplier;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.Diagnostic;
import org.qbicc.context.Location;
import org.qbicc.context.PhaseAttachmentKey;
import org.qbicc.graph.Node;
import org.qbicc.type.definition.element.Element;

public interface DiagnosticContext {
    public <T> T getAttachment(AttachmentKey<T> var1);

    public <T> T getAttachmentOrDefault(AttachmentKey<T> var1, T var2);

    public <T> T putAttachment(AttachmentKey<T> var1, T var2);

    public <T> T putAttachmentIfAbsent(AttachmentKey<T> var1, T var2);

    public <T> T removeAttachment(AttachmentKey<T> var1);

    public <T> boolean removeAttachment(AttachmentKey<T> var1, T var2);

    public <T> T replaceAttachment(AttachmentKey<T> var1, T var2);

    public <T> boolean replaceAttachment(AttachmentKey<T> var1, T var2, T var3);

    public <T> T computeAttachmentIfAbsent(AttachmentKey<T> var1, Supplier<T> var2);

    public <T> T computeAttachmentIfPresent(AttachmentKey<T> var1, Function<T, T> var2);

    public <T> T computeAttachment(AttachmentKey<T> var1, Function<T, T> var2);

    public <T> T getAttachment(PhaseAttachmentKey<T> var1);

    public <T> T getAttachmentOrDefault(PhaseAttachmentKey<T> var1, T var2);

    public <T> T putAttachment(PhaseAttachmentKey<T> var1, T var2);

    public <T> T putAttachmentIfAbsent(PhaseAttachmentKey<T> var1, T var2);

    public <T> T removeAttachment(PhaseAttachmentKey<T> var1);

    public <T> boolean removeAttachment(PhaseAttachmentKey<T> var1, T var2);

    public <T> T replaceAttachment(PhaseAttachmentKey<T> var1, T var2);

    public <T> boolean replaceAttachment(PhaseAttachmentKey<T> var1, T var2, T var3);

    public <T> T computeAttachmentIfAbsent(PhaseAttachmentKey<T> var1, Supplier<T> var2);

    public <T> T computeAttachmentIfPresent(PhaseAttachmentKey<T> var1, Function<T, T> var2);

    public <T> T computeAttachment(PhaseAttachmentKey<T> var1, Function<T, T> var2);

    public void cyclePhaseAttachments();

    public <T> T getPreviousPhaseAttachment(PhaseAttachmentKey<T> var1);

    public int errors();

    public int warnings();

    public Diagnostic msg(Diagnostic var1, Location var2, Diagnostic.Level var3, String var4, Object ... var5);

    public Diagnostic msg(Diagnostic var1, Element var2, Node var3, Diagnostic.Level var4, String var5, Object ... var6);

    default public Diagnostic error(Diagnostic parent, Element element, Node node, String fmt, Object ... args) {
        return this.msg(parent, element, node, Diagnostic.Level.ERROR, fmt, args);
    }

    default public Diagnostic error(Element element, Node node, String fmt, Object ... args) {
        return this.msg(null, element, node, Diagnostic.Level.ERROR, fmt, args);
    }

    default public Diagnostic error(Diagnostic parent, Element element, String fmt, Object ... args) {
        return this.msg(parent, element, null, Diagnostic.Level.ERROR, fmt, args);
    }

    default public Diagnostic error(Element element, String fmt, Object ... args) {
        return this.msg(null, element, null, Diagnostic.Level.ERROR, fmt, args);
    }

    default public Diagnostic error(Diagnostic parent, Location location, String fmt, Object ... args) {
        return this.msg(parent, location, Diagnostic.Level.ERROR, fmt, args);
    }

    default public Diagnostic error(Location location, String fmt, Object ... args) {
        return this.msg(null, location, Diagnostic.Level.ERROR, fmt, args);
    }

    default public Diagnostic error(Diagnostic parent, String fmt, Object ... args) {
        return this.msg(parent, Location.NO_LOC, Diagnostic.Level.ERROR, fmt, args);
    }

    default public Diagnostic error(String fmt, Object ... args) {
        return this.msg(null, null, null, Diagnostic.Level.ERROR, fmt, args);
    }

    default public Diagnostic error(Throwable t, String fmt, Object ... args) {
        return this.error(t, null, null, null, fmt, args);
    }

    default public Diagnostic error(Throwable t, Element element, String fmt, Object ... args) {
        return this.error(t, null, element, null, fmt, args);
    }

    default public Diagnostic error(Throwable t, Element element, Node node, String fmt, Object ... args) {
        return this.error(t, null, element, node, fmt, args);
    }

    default public Diagnostic error(Throwable t, Diagnostic parent, Element element, Node node, String fmt, Object ... args) {
        if (t == null) {
            return this.error(parent, element, node, fmt, args);
        }
        Diagnostic outer = this.error(parent, element, node, fmt, args);
        this.note(outer, Location.fromStackTrace(t), "This is the location of the exception", new Object[0]);
        return outer;
    }

    default public Diagnostic warning(Diagnostic parent, Element element, Node node, String fmt, Object ... args) {
        return this.msg(parent, element, node, Diagnostic.Level.WARNING, fmt, args);
    }

    default public Diagnostic warning(Element element, Node node, String fmt, Object ... args) {
        return this.msg(null, element, node, Diagnostic.Level.WARNING, fmt, args);
    }

    default public Diagnostic warning(Diagnostic parent, Element element, String fmt, Object ... args) {
        return this.msg(parent, element, null, Diagnostic.Level.WARNING, fmt, args);
    }

    default public Diagnostic warning(Element element, String fmt, Object ... args) {
        return this.msg(null, element, null, Diagnostic.Level.WARNING, fmt, args);
    }

    default public Diagnostic warning(Diagnostic parent, Location location, String fmt, Object ... args) {
        return this.msg(parent, location, Diagnostic.Level.WARNING, fmt, args);
    }

    default public Diagnostic warning(Location location, String fmt, Object ... args) {
        return this.msg(null, location, Diagnostic.Level.WARNING, fmt, args);
    }

    default public Diagnostic warning(Diagnostic parent, String fmt, Object ... args) {
        return this.msg(parent, Location.NO_LOC, Diagnostic.Level.WARNING, fmt, args);
    }

    default public Diagnostic warning(String fmt, Object ... args) {
        return this.msg(null, null, null, Diagnostic.Level.WARNING, fmt, args);
    }

    default public Diagnostic warning(Throwable t, String fmt, Object ... args) {
        return this.warning(t, null, null, null, fmt, args);
    }

    default public Diagnostic warning(Throwable t, Element element, String fmt, Object ... args) {
        return this.warning(t, null, element, null, fmt, args);
    }

    default public Diagnostic warning(Throwable t, Element element, Node node, String fmt, Object ... args) {
        return this.warning(t, null, element, node, fmt, args);
    }

    default public Diagnostic warning(Throwable t, Diagnostic parent, Element element, Node node, String fmt, Object ... args) {
        if (t == null) {
            return this.warning(parent, element, node, fmt, args);
        }
        Diagnostic outer = this.warning(parent, element, node, fmt, args);
        this.note(outer, Location.fromStackTrace(t), "This is the location of the exception", new Object[0]);
        return outer;
    }

    default public Diagnostic note(Diagnostic parent, Element element, Node node, String fmt, Object ... args) {
        return this.msg(parent, element, node, Diagnostic.Level.NOTE, fmt, args);
    }

    default public Diagnostic note(Element element, Node node, String fmt, Object ... args) {
        return this.msg(null, element, node, Diagnostic.Level.NOTE, fmt, args);
    }

    default public Diagnostic note(Diagnostic parent, Element element, String fmt, Object ... args) {
        return this.msg(parent, element, null, Diagnostic.Level.NOTE, fmt, args);
    }

    default public Diagnostic note(Element element, String fmt, Object ... args) {
        return this.msg(null, element, null, Diagnostic.Level.NOTE, fmt, args);
    }

    default public Diagnostic note(Diagnostic parent, Location location, String fmt, Object ... args) {
        return this.msg(parent, location, Diagnostic.Level.NOTE, fmt, args);
    }

    default public Diagnostic note(Location location, String fmt, Object ... args) {
        return this.msg(null, location, Diagnostic.Level.NOTE, fmt, args);
    }

    default public Diagnostic note(Diagnostic parent, String fmt, Object ... args) {
        return this.msg(parent, Location.NO_LOC, Diagnostic.Level.NOTE, fmt, args);
    }

    default public Diagnostic note(String fmt, Object ... args) {
        return this.msg(null, null, null, Diagnostic.Level.NOTE, fmt, args);
    }

    default public Diagnostic info(Diagnostic parent, Element element, Node node, String fmt, Object ... args) {
        return this.msg(parent, element, node, Diagnostic.Level.INFO, fmt, args);
    }

    default public Diagnostic info(Element element, Node node, String fmt, Object ... args) {
        return this.msg(null, element, node, Diagnostic.Level.INFO, fmt, args);
    }

    default public Diagnostic info(Diagnostic parent, Element element, String fmt, Object ... args) {
        return this.msg(parent, element, null, Diagnostic.Level.INFO, fmt, args);
    }

    default public Diagnostic info(Element element, String fmt, Object ... args) {
        return this.msg(null, element, null, Diagnostic.Level.INFO, fmt, args);
    }

    default public Diagnostic info(Diagnostic parent, Location location, String fmt, Object ... args) {
        return this.msg(parent, location, Diagnostic.Level.INFO, fmt, args);
    }

    default public Diagnostic info(Location location, String fmt, Object ... args) {
        return this.msg(null, location, Diagnostic.Level.INFO, fmt, args);
    }

    default public Diagnostic info(Diagnostic parent, String fmt, Object ... args) {
        return this.msg(parent, Location.NO_LOC, Diagnostic.Level.INFO, fmt, args);
    }

    default public Diagnostic info(String fmt, Object ... args) {
        return this.msg(null, null, null, Diagnostic.Level.INFO, fmt, args);
    }

    default public Diagnostic debug(Diagnostic parent, Element element, Node node, String fmt, Object ... args) {
        return this.msg(parent, element, node, Diagnostic.Level.DEBUG, fmt, args);
    }

    default public Diagnostic debug(Element element, Node node, String fmt, Object ... args) {
        return this.msg(null, element, node, Diagnostic.Level.DEBUG, fmt, args);
    }

    default public Diagnostic debug(Diagnostic parent, Element element, String fmt, Object ... args) {
        return this.msg(parent, element, null, Diagnostic.Level.DEBUG, fmt, args);
    }

    default public Diagnostic debug(Element element, String fmt, Object ... args) {
        return this.msg(null, element, null, Diagnostic.Level.DEBUG, fmt, args);
    }

    default public Diagnostic debug(Diagnostic parent, Location location, String fmt, Object ... args) {
        return this.msg(parent, location, Diagnostic.Level.DEBUG, fmt, args);
    }

    default public Diagnostic debug(Location location, String fmt, Object ... args) {
        return this.msg(null, location, Diagnostic.Level.DEBUG, fmt, args);
    }

    default public Diagnostic debug(Diagnostic parent, String fmt, Object ... args) {
        return this.msg(parent, Location.NO_LOC, Diagnostic.Level.DEBUG, fmt, args);
    }

    default public Diagnostic debug(String fmt, Object ... args) {
        return this.msg(null, null, null, Diagnostic.Level.DEBUG, fmt, args);
    }

    public Iterable<Diagnostic> getDiagnostics();
}

