/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.context;

import io.smallrye.common.constraint.Assert;
import org.qbicc.graph.Node;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.BasicElement;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.NamedElement;

public final class Location {
    public static final Location NO_LOC = Location.builder().build();
    private final String classSimpleName;
    private final String classInternalName;
    private final String classFilePath;
    private final String sourceFilePath;
    private final MemberKind memberKind;
    private final String memberName;
    private final int lineNumber;
    private final int byteCodeIndex;

    Location(Builder builder) {
        String internalName = builder.classInternalName;
        if (internalName != null && !internalName.isEmpty()) {
            this.classInternalName = internalName;
            int i = internalName.lastIndexOf(47);
            this.classSimpleName = i >= 0 ? internalName.substring(i + 1) : internalName;
        } else {
            this.classSimpleName = null;
            this.classInternalName = null;
        }
        this.classFilePath = builder.classFilePath;
        this.sourceFilePath = builder.sourceFilePath;
        this.memberKind = builder.memberKind;
        this.memberName = builder.memberName;
        this.lineNumber = Math.max(0, builder.lineNumber);
        this.byteCodeIndex = Math.max(-1, builder.byteCodeIndex);
    }

    public String getClassSimpleName() {
        return this.classSimpleName;
    }

    public String getClassInternalName() {
        return this.classInternalName;
    }

    public boolean hasClassName() {
        return this.classInternalName != null;
    }

    public String getClassFilePath() {
        return this.classFilePath;
    }

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public MemberKind getMemberKind() {
        return this.memberKind;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public boolean hasMemberName() {
        return this.memberName != null;
    }

    public boolean hasLocation() {
        return this.sourceFilePath != null || this.classFilePath != null || this.classInternalName != null || this.lineNumber > 0;
    }

    public int getByteCodeIndex() {
        return this.byteCodeIndex;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.appendBaseString(b);
        if (this.hasMemberName()) {
            b.append("; ");
            this.appendMemberString(b);
        }
        if (this.hasClassName()) {
            b.append("; ");
            this.appendLocationString(b);
        }
        return b.toString();
    }

    public StringBuilder appendMemberString(StringBuilder b) {
        b.append("member: ").append((Object)this.memberKind).append(' ').append(this.memberName);
        if (this.byteCodeIndex >= 0) {
            b.append("@ bci ").append(this.byteCodeIndex);
        }
        return b;
    }

    public StringBuilder appendLocationString(StringBuilder b) {
        return b.append("location: type ").append(this.classSimpleName);
    }

    public StringBuilder appendBaseString(StringBuilder b) {
        if (this.sourceFilePath != null) {
            b.append(this.sourceFilePath);
        } else if (this.classFilePath != null) {
            b.append(this.classFilePath);
        } else if (this.classInternalName != null) {
            b.append(this.classInternalName).append(".class");
        } else {
            b.append("<no location>");
        }
        if (this.lineNumber > 0) {
            b.append(':');
            b.append(this.lineNumber);
        }
        return b;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Location fromStackTrace(Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        if (elements.length >= 1) {
            StackTraceElement element = elements[0];
            return Location.builder().setSourceFilePath(element.getFileName()).setClassInternalName(element.getClassName().replace('.', '/')).setLineNumber(element.getLineNumber()).setMemberName(element.getMethodName()).setMemberKind(MemberKind.METHOD).build();
        }
        return NO_LOC;
    }

    public static final class Builder {
        private String classInternalName;
        private String classFilePath;
        private String sourceFilePath;
        private MemberKind memberKind = MemberKind.NONE;
        private String memberName;
        private int lineNumber = 0;
        private int byteCodeIndex = -1;

        Builder() {
        }

        public String getClassInternalName() {
            return this.classInternalName;
        }

        public Builder setClassInternalName(String classInternalName) {
            this.classInternalName = classInternalName;
            return this;
        }

        public String getClassFilePath() {
            return this.classFilePath;
        }

        public Builder setClassFilePath(String classFilePath) {
            this.classFilePath = classFilePath;
            return this;
        }

        public String getSourceFilePath() {
            return this.sourceFilePath;
        }

        public Builder setSourceFilePath(String sourceFilePath) {
            this.sourceFilePath = sourceFilePath;
            return this;
        }

        public MemberKind getMemberKind() {
            return this.memberKind;
        }

        public Builder setMemberKind(MemberKind memberKind) {
            this.memberKind = (MemberKind)((Object)Assert.checkNotNullParam((String)"memberKind", (Object)((Object)memberKind)));
            return this;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public Builder setMemberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public Builder setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public int getByteCodeIndex() {
            return this.byteCodeIndex;
        }

        public Builder setByteCodeIndex(int byteCodeIndex) {
            this.byteCodeIndex = byteCodeIndex;
            return this;
        }

        public Builder setElement(Element element) {
            if (element instanceof MethodElement) {
                this.setMemberKind(MemberKind.METHOD);
            } else if (element instanceof ConstructorElement) {
                this.setMemberKind(MemberKind.CONSTRUCTOR);
                this.setMemberName("<init>");
            } else if (element instanceof FieldElement) {
                this.setMemberKind(MemberKind.FIELD);
            } else {
                this.setMemberKind(MemberKind.NONE);
            }
            if (element instanceof NamedElement) {
                this.setMemberName(((NamedElement)element).getName());
            }
            if (element instanceof BasicElement) {
                this.setSourceFilePath(element.getSourceFileName());
            }
            if (element != null) {
                this.setClassInternalName(element.getEnclosingType().getInternalName());
            }
            return this;
        }

        public Builder setType(DefinedTypeDefinition def) {
            this.setClassInternalName(def.getInternalName());
            return this;
        }

        public Builder setNode(Node node) {
            this.setElement(node.getElement());
            this.setLineNumber(node.getSourceLine());
            this.setByteCodeIndex(node.getBytecodeIndex());
            return this;
        }

        public Location build() {
            return new Location(this);
        }
    }

    public static enum MemberKind {
        NONE("member"),
        FIELD("field"),
        CONSTRUCTOR("constructor"),
        METHOD("method"),
        VARIABLE("variable"),
        FUNCTION("function");

        final String str;

        private MemberKind(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

