/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.facts;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectIntMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.PhaseAttachmentKey;
import org.qbicc.facts.Condition;
import org.qbicc.facts.Fact;

public final class Facts {
    private static final VarHandle factIdsHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "factIds", VarHandle.class, Facts.class, ImmutableObjectIntMap.class);
    private static final VarHandle longArrayHandle = ConstantBootstraps.arrayVarHandle(MethodHandles.lookup(), "_", VarHandle.class, long[].class);
    private final CompilationContext ctxt;
    private static final AttachmentKey<Facts> KEY = new AttachmentKey();
    private static final PhaseAttachmentKey<PerPhase> PER_PHASE_KEY = new PhaseAttachmentKey();
    private volatile ImmutableObjectIntMap<Fact<?>> factIds = ObjectIntMaps.immutable.empty();

    private Facts(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static Facts get(CompilationContext ctxt) {
        Facts appearing;
        Facts facts = ctxt.getAttachment(KEY);
        if (facts == null && (appearing = ctxt.putAttachmentIfAbsent(KEY, facts = new Facts(ctxt))) != null) {
            facts = appearing;
        }
        return facts;
    }

    int getFactIndex(Fact<?> fact) {
        int id;
        ImmutableObjectIntMap newMap;
        ImmutableObjectIntMap<Fact<?>> oldMap;
        do {
            if ((id = (oldMap = this.factIds).getIfAbsent(fact, -1)) != -1) {
                return id;
            }
            id = oldMap.size();
            if (id < 64) continue;
            throw new IllegalStateException("Too many facts");
        } while (!factIdsHandle.compareAndSet(this, oldMap, newMap = oldMap.newWithKeyValue(fact, id)));
        return id;
    }

    private PerPhase getPerPhase() {
        PerPhase appearing;
        PerPhase perPhase = this.ctxt.getAttachment(PER_PHASE_KEY);
        if (perPhase == null && (appearing = this.ctxt.putAttachmentIfAbsent(PER_PHASE_KEY, perPhase = new PerPhase())) != null) {
            perPhase = appearing;
        }
        return perPhase;
    }

    private PerPhase getPreviousPerPhase() {
        return this.ctxt.getPreviousPhaseAttachment(PER_PHASE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAction(long bits, BiConsumer<?, Facts> consumer) {
        PerPhase perPhase;
        PerPhase perPhase2 = perPhase = this.getPerPhase();
        synchronized (perPhase2) {
            ImmutableList newActions;
            Action action = new Action(bits, consumer);
            perPhase.actions = newActions = perPhase.actions.newWith(action);
            Map<Object, long[]> factsMap = perPhase.facts;
            if (!factsMap.isEmpty()) {
                int actionBit = newActions.size() - 1;
                block3: for (Map.Entry<Object, long[]> entry : factsMap.entrySet()) {
                    long newVal;
                    long oldVal;
                    long[] array = entry.getValue();
                    long factBits = longArrayHandle.getVolatile(array, 0);
                    if (!action.isNewlySatisfiedBy(0L, factBits)) continue;
                    while ((oldVal = longArrayHandle.getVolatile(array, 1)) != (newVal = oldVal | 1L << actionBit)) {
                        if (!longArrayHandle.compareAndSet(array, 1, oldVal, newVal)) continue;
                        action.accept(entry.getKey());
                        continue block3;
                    }
                }
            }
        }
    }

    private static long[] newArray(Object ignored) {
        return new long[2];
    }

    private <E> long discover(E item, long factBits) {
        long newFacts;
        long oldFacts;
        PerPhase perPhase = this.getPerPhase();
        Map<Object, long[]> facts = perPhase.facts;
        long[] array = facts.computeIfAbsent(item, Facts::newArray);
        do {
            if (((oldFacts = longArrayHandle.getVolatile(array, 0)) & factBits) != factBits) continue;
            return 0L;
        } while (!longArrayHandle.compareAndSet(array, 0, oldFacts, newFacts = oldFacts | factBits));
        ImmutableList<Action<?>> actions = perPhase.actions;
        int size = actions.size();
        block1: for (int i = 0; i < size; ++i) {
            long newVal;
            long oldVal;
            Action action = (Action)actions.get(i);
            if (!action.isNewlySatisfiedBy(oldFacts, newFacts)) continue;
            while ((oldVal = longArrayHandle.getVolatile(array, 1)) != (newVal = oldVal | 1L << i)) {
                if (!longArrayHandle.compareAndSet(array, 1, oldVal, newVal)) continue;
                action.accept(item);
                continue block1;
            }
        }
        return newFacts & (oldFacts ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public <E> void discover(E item, Fact<? super E> fact) {
        fact.getElementType().cast(item);
        if (this.discover(item, 1L << this.getFactIndex(fact)) != 0L) {
            longArrayHandle.getAndAdd(this.getPerPhase().counts.computeIfAbsent(fact, Facts::newArray), 0, 1L);
        }
    }

    public <E> void discover(E item, Fact<? super E> fact1, Fact<? super E> fact2) {
        fact1.getElementType().cast(item);
        fact2.getElementType().cast(item);
        long bit1 = 1L << this.getFactIndex(fact1);
        long bit2 = 1L << this.getFactIndex(fact2);
        long newly = this.discover(item, bit1 | bit2);
        PerPhase perPhase = this.getPerPhase();
        if ((newly & bit1) != 0L) {
            longArrayHandle.getAndAdd(perPhase.counts.computeIfAbsent(fact1, Facts::newArray), 0, 1L);
        }
        if ((newly & bit2) != 0L) {
            longArrayHandle.getAndAdd(perPhase.counts.computeIfAbsent(fact2, Facts::newArray), 0, 1L);
        }
    }

    public <E> void discover(E item, Fact<? super E> fact1, Fact<? super E> fact2, Fact<? super E> fact3) {
        fact1.getElementType().cast(item);
        fact2.getElementType().cast(item);
        fact3.getElementType().cast(item);
        long bit1 = 1L << this.getFactIndex(fact1);
        long bit2 = 1L << this.getFactIndex(fact2);
        long bit3 = 1L << this.getFactIndex(fact3);
        long newly = this.discover(item, bit1 | bit2 | bit3);
        PerPhase perPhase = this.getPerPhase();
        if ((newly & bit1) != 0L) {
            longArrayHandle.getAndAdd(perPhase.counts.computeIfAbsent(fact1, Facts::newArray), 0, 1L);
        }
        if ((newly & bit2) != 0L) {
            longArrayHandle.getAndAdd(perPhase.counts.computeIfAbsent(fact2, Facts::newArray), 0, 1L);
        }
        if ((newly & bit3) != 0L) {
            longArrayHandle.getAndAdd(perPhase.counts.computeIfAbsent(fact3, Facts::newArray), 0, 1L);
        }
    }

    public long getDiscoveredCount(Fact<?> fact) {
        long[] array = this.getPerPhase().counts.get(fact);
        return array == null ? 0L : longArrayHandle.getVolatile(array, 0);
    }

    public <E> boolean isDiscovered(E item, Fact<? super E> fact) {
        long[] array = this.getPerPhase().facts.get(item);
        long factBits = 1L << this.getFactIndex(fact);
        return array != null && fact.getElementType().isInstance(item) && (array[0] & factBits) == factBits;
    }

    private <E> boolean hadAllFactBits(E item, long factBits) {
        PerPhase previous = this.getPreviousPerPhase();
        if (previous == null) {
            return false;
        }
        long[] array = previous.facts.get(item);
        return array != null && (array[0] & factBits) == factBits;
    }

    private <E> boolean hadAnyFactBits(E item, long factBits) {
        PerPhase previous = this.getPreviousPerPhase();
        if (previous == null) {
            return false;
        }
        long[] array = previous.facts.get(item);
        return array != null && (array[0] & factBits) != 0L;
    }

    public <E> boolean hadFact(E item, Fact<? super E> fact) {
        return fact.getElementType().isInstance(item) && this.hadAllFactBits(item, 1L << this.getFactIndex(fact));
    }

    public <E> boolean hadAllFacts(E item, Fact<? super E> fact1, Fact<? super E> fact2) {
        return fact1.getElementType().isInstance(item) && fact2.getElementType().isInstance(item) && this.hadAllFactBits(item, 1L << this.getFactIndex(fact1) | 1L << this.getFactIndex(fact2));
    }

    public <E> boolean hadAllFacts(E item, Fact<? super E> fact1, Fact<? super E> fact2, Fact<? super E> fact3) {
        return fact1.getElementType().isInstance(item) && fact2.getElementType().isInstance(item) && fact3.getElementType().isInstance(item) && this.hadAllFactBits(item, 1L << this.getFactIndex(fact1) | 1L << this.getFactIndex(fact2) | 1L << this.getFactIndex(fact3));
    }

    public <E> boolean hadAnyFacts(E item, Fact<? super E> fact1, Fact<? super E> fact2) {
        return fact1.getElementType().isInstance(item) && fact2.getElementType().isInstance(item) && this.hadAnyFactBits(item, 1L << this.getFactIndex(fact1) | 1L << this.getFactIndex(fact2));
    }

    public <E> boolean hadAnyFacts(E item, Fact<? super E> fact1, Fact<? super E> fact2, Fact<? super E> fact3) {
        return fact1.getElementType().isInstance(item) && fact2.getElementType().isInstance(item) && fact3.getElementType().isInstance(item) && this.hadAnyFactBits(item, 1L << this.getFactIndex(fact1) | 1L << this.getFactIndex(fact2) | 1L << this.getFactIndex(fact3));
    }

    public <E> void registerInlineAction(Condition<? extends Fact<? super E>> condition, BiConsumer<E, Facts> action) {
        condition.getRegisterFunction((facts, bits) -> facts.registerAction(bits, action)).accept(this, 0L);
    }

    public <E> void registerInlineAction(Condition<? extends Fact<? super E>> condition, Consumer<E> action) {
        this.registerInlineAction(condition, (E e, Facts f) -> action.accept(e));
    }

    public <E> void registerAction(Condition<? extends Fact<? super E>> condition, BiConsumer<E, Facts> action) {
        BiConsumer<Object, Facts> bc = (e, f) -> this.ctxt.submitTask(e, e2 -> action.accept((Object)e2, (Facts)f));
        condition.getRegisterFunction((facts, bits) -> facts.registerAction(bits, bc)).accept(this, 0L);
    }

    public <E> void registerAction(Condition<? extends Fact<? super E>> condition, Consumer<E> action) {
        this.registerAction(condition, (E e, Facts f) -> action.accept(e));
    }

    public CompilationContext getCompilationContext() {
        return this.ctxt;
    }

    public boolean hasPreviousFacts() {
        return this.ctxt.getPreviousPhaseAttachment(PER_PHASE_KEY) != null;
    }

    static final class PerPhase {
        final Map<Object, long[]> facts = new ConcurrentHashMap<Object, long[]>();
        final Map<Fact<?>, long[]> counts = new ConcurrentHashMap();
        volatile ImmutableList<Action<?>> actions = Lists.immutable.empty();

        PerPhase() {
        }
    }

    final class Action<K>
    implements Consumer<Object> {
        private final long requiredBits;
        private final BiConsumer<K, Facts> consumer;

        Action(long requiredBits, BiConsumer<K, Facts> consumer) {
            this.requiredBits = requiredBits;
            this.consumer = consumer;
        }

        boolean isNewlySatisfiedBy(long oldBits, long newBits) {
            long requiredBits = this.requiredBits;
            return (oldBits & requiredBits) != requiredBits && (newBits & requiredBits) == requiredBits;
        }

        @Override
        public void accept(Object item) {
            this.consumer.accept(item, Facts.this);
        }
    }
}

