/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.BinaryValue;
import org.qbicc.graph.CommutativeBinaryValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.NonCommutativeBinaryValue;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;

abstract class AbstractBinaryValue
extends AbstractValue
implements BinaryValue {
    final Value left;
    final Value right;

    AbstractBinaryValue(Node callSite, ExecutableElement element, int line, int bci, Value left, Value right) {
        super(callSite, element, line, bci);
        this.left = left;
        this.right = right;
    }

    @Override
    public Value getLeftInput() {
        return this.left;
    }

    @Override
    public Value getRightInput() {
        return this.right;
    }

    @Override
    int calcHashCode() {
        if (this instanceof CommutativeBinaryValue) {
            return this.getClass().hashCode() * 19 + (this.left.hashCode() ^ this.right.hashCode());
        }
        assert (this instanceof NonCommutativeBinaryValue);
        return Objects.hash(this.getClass(), this.left, this.right);
    }

    @Override
    public boolean equals(Object other) {
        return other.getClass().equals(this.getClass()) && this.equals((AbstractBinaryValue)other);
    }

    boolean equals(AbstractBinaryValue other) {
        return this == other || this.getClass() == other.getClass() && (this.left.equals(other.left) && this.right.equals(other.right) || this instanceof CommutativeBinaryValue && this.left.equals(other.right) && this.right.equals(other.left));
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.getLeftInput().toReferenceString(b);
        b.append(',');
        this.getRightInput().toReferenceString(b);
        b.append(')');
        return b;
    }
}

