/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.type.PointerType;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.InstanceMethodElement;

public abstract class AbstractMethodLookup
extends AbstractValue
implements OrderedNode {
    private final Node dependency;
    private final Value reference;
    private final InstanceMethodElement method;

    public AbstractMethodLookup(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value reference, InstanceMethodElement method) {
        super(callSite, element, line, bci);
        while (dependency instanceof OrderedNode) {
            OrderedNode on = (OrderedNode)dependency;
            dependency = on.getDependency();
        }
        this.dependency = dependency;
        this.reference = reference;
        this.method = method;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.getClass(), this.dependency, this.reference, this.method);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    public Value getReference() {
        return this.reference;
    }

    public InstanceMethodElement getMethod() {
        return this.method;
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        return this.reference.toReferenceString(b.append("lookup ").append(this.getLabel()).append(' ').append(this.method).append(" for "));
    }

    abstract String getLabel();

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(index);
            }
        }
        return this.reference;
    }

    @Override
    public final boolean equals(Object other) {
        AbstractMethodLookup aml;
        return other instanceof AbstractMethodLookup && this.equals(aml = (AbstractMethodLookup)other);
    }

    public boolean equals(AbstractMethodLookup other) {
        return other == this || other != null && this.dependency.equals(other.dependency) && this.reference.equals(other.reference) && this.method.equals(other.method);
    }

    @Override
    public PointerType getType() {
        return this.method.getType().getPointer();
    }
}

