/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.PointerType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Auto
extends AbstractValue
implements OrderedNode {
    private final Node dependency;
    private final Value initializer;

    Auto(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value initializer) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.initializer = initializer;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.dependency, this.initializer);
    }

    @Override
    String getNodeName() {
        return "Auto";
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        return this.initializer.toReferenceString(b.append("auto "));
    }

    @Override
    public boolean equals(Object other) {
        Auto a;
        return other instanceof Auto && this.equals(a = (Auto)other);
    }

    public boolean equals(Auto other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.initializer.equals(other.initializer);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(index);
            }
        }
        return this.initializer;
    }

    public Value getInitializer() {
        return this.initializer;
    }

    @Override
    public PointerType getType() {
        return this.initializer.getType().getPointer();
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

