/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import io.smallrye.common.constraint.Assert;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.Node;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.Value;

public final class BasicBlock {
    private final BlockEntry blockEntry;
    private final Terminator terminator;
    private BlockLabel myLabel;
    private boolean reachable;
    private Set<BasicBlock> incoming = Set.of();
    private Set<Loop> loops = Set.of();
    private int index;
    private List<Node> instructions;
    private Map<Slot, BlockParameter> usedParameters;

    BasicBlock(BlockEntry blockEntry, Terminator terminator) {
        this.blockEntry = blockEntry;
        this.terminator = terminator;
    }

    public BlockEntry getBlockEntry() {
        return this.blockEntry;
    }

    public Terminator getTerminator() {
        return this.terminator;
    }

    BlockLabel getHandle() {
        BlockLabel myHandle = this.myLabel;
        if (myHandle == null) {
            myHandle = this.myLabel = new BlockLabel();
            myHandle.setTarget(this);
        }
        return myHandle;
    }

    BlockLabel getHandleIfExists() {
        return this.myLabel;
    }

    void setHandle(BlockLabel newHandle) {
        assert (this.myLabel == null);
        this.myLabel = newHandle;
    }

    public List<Node> getInstructions() {
        List<Node> instructions = this.instructions;
        if (instructions == null) {
            throw new IllegalStateException("Scheduling is not yet complete");
        }
        return instructions;
    }

    public void setInstructions(List<Node> instructions) {
        this.instructions = instructions;
    }

    public BlockParameter getBlockParameter(Slot slot) {
        Map<Slot, BlockParameter> usedParameters = this.usedParameters;
        if (usedParameters == null) {
            throw new IllegalStateException("Scheduling is not yet complete");
        }
        return usedParameters.get(slot);
    }

    public Set<Slot> getUsedParameterSlots() {
        Map<Slot, BlockParameter> usedParameters = this.usedParameters;
        if (usedParameters == null) {
            throw new IllegalStateException("Scheduling is not yet complete");
        }
        return usedParameters.keySet();
    }

    public void setUsedParameters(Map<Slot, BlockParameter> usedParameters) {
        this.usedParameters = usedParameters;
    }

    public Set<Loop> getLoops() {
        return this.loops;
    }

    void setLoops(Set<Loop> loops) {
        this.loops = loops;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public boolean setReachableFrom(BasicBlock from) {
        boolean old;
        if (from != null && !this.incoming.contains(from)) {
            if (this.incoming.isEmpty()) {
                this.incoming = Set.of(from);
            } else if (this.incoming.size() == 1) {
                this.incoming = Set.of(from, this.incoming.iterator().next());
            } else if (this.incoming.size() == 2) {
                Set<BasicBlock> old2 = this.incoming;
                this.incoming = new LinkedHashSet<BasicBlock>();
                this.incoming.addAll(old2);
                this.incoming.add(from);
            } else {
                this.incoming.add(from);
            }
        }
        if (old = this.reachable) {
            return false;
        }
        this.reachable = true;
        return true;
    }

    public Set<BasicBlock> getIncoming() {
        return this.incoming;
    }

    public boolean isSucceededBy(BasicBlock block) {
        int cnt = this.terminator.getSuccessorCount();
        for (int i = 0; i < cnt; ++i) {
            if (!block.equals(this.terminator.getSuccessor(i))) continue;
            return true;
        }
        return false;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public Set<Value> getLiveOuts() {
        return this.terminator.getLiveOuts();
    }

    public StringBuilder toString(StringBuilder b) {
        return b.append("bb").append(this.index);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public static final class Loop {
        private final BasicBlock startBlock;
        private final BasicBlock endBlock;

        public Loop(BasicBlock startBlock, BasicBlock endBlock) {
            this.startBlock = (BasicBlock)Assert.checkNotNullParam((String)"startBlock", (Object)startBlock);
            this.endBlock = (BasicBlock)Assert.checkNotNullParam((String)"endBlock", (Object)endBlock);
        }

        public BasicBlock getStartBlock() {
            return this.startBlock;
        }

        public BasicBlock getEndBlock() {
            return this.endBlock;
        }

        public int hashCode() {
            return Objects.hash(this.startBlock, this.endBlock);
        }

        public boolean equals(Object obj) {
            return obj instanceof Loop && this.equals((Loop)obj);
        }

        public boolean equals(Loop obj) {
            return this == obj || obj != null && this.startBlock == obj.startBlock && this.endBlock == obj.endBlock;
        }
    }
}

