/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import io.smallrye.common.constraint.Assert;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Locatable;
import org.qbicc.context.Location;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.CheckCast;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.Node;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.SimpleBasicBlockBuilder;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.GlobalAccessMode;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.NullableType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.PrimitiveArrayObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnionType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.LocalVariableElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.methodhandle.MethodMethodHandleConstant;

public interface BasicBlockBuilder
extends Locatable {
    public BlockParameter addParam(BlockLabel var1, Slot var2, ValueType var3, boolean var4);

    default public BlockParameter addParam(BlockLabel owner, Slot slot, ValueType type) {
        return this.addParam(owner, slot, type, type instanceof NullableType);
    }

    public BlockParameter getParam(BlockLabel var1, Slot var2) throws NoSuchElementException;

    default public ClassContext getCurrentClassContext() {
        return this.getCurrentElement().getEnclosingType().getContext();
    }

    default public CompilationContext getContext() {
        return this.getCurrentClassContext().getCompilationContext();
    }

    default public LiteralFactory getLiteralFactory() {
        return this.getCurrentClassContext().getLiteralFactory();
    }

    default public TypeSystem getTypeSystem() {
        return this.getCurrentClassContext().getTypeSystem();
    }

    public BasicBlockBuilder getFirstBuilder();

    public void setFirstBuilder(BasicBlockBuilder var1);

    public ExecutableElement getCurrentElement();

    public ExecutableElement getRootElement();

    public ExecutableElement setCurrentElement(ExecutableElement var1);

    public Node getCallSite();

    public Node setCallSite(Node var1);

    @Override
    public Location getLocation();

    public int setLineNumber(int var1);

    public int setBytecodeIndex(int var1);

    public int getBytecodeIndex();

    public void finish();

    public BasicBlock getFirstBlock() throws IllegalStateException;

    public BlockLabel getEntryLabel() throws IllegalStateException;

    default public Literal emptyVoid() {
        return this.getLiteralFactory().zeroInitializerLiteralOfType(this.getTypeSystem().getVoidType());
    }

    public Value offsetOfField(FieldElement var1);

    public Value extractElement(Value var1, Value var2);

    public Value extractMember(Value var1, CompoundType.Member var2);

    public Value extractInstanceField(Value var1, TypeDescriptor var2, String var3, TypeDescriptor var4);

    public Value extractInstanceField(Value var1, FieldElement var2);

    public Value insertElement(Value var1, Value var2, Value var3);

    public Value insertMember(Value var1, CompoundType.Member var2, Value var3);

    public Node declareDebugAddress(LocalVariableElement var1, Value var2);

    public Node setDebugValue(LocalVariableElement var1, Value var2);

    public Value select(Value var1, Value var2, Value var3);

    public Value add(Value var1, Value var2);

    public Value multiply(Value var1, Value var2);

    public Value and(Value var1, Value var2);

    public Value or(Value var1, Value var2);

    public Value xor(Value var1, Value var2);

    public Value isEq(Value var1, Value var2);

    public Value isNe(Value var1, Value var2);

    public Value shr(Value var1, Value var2);

    public Value shl(Value var1, Value var2);

    public Value sub(Value var1, Value var2);

    public Value divide(Value var1, Value var2);

    public Value remainder(Value var1, Value var2);

    public Value min(Value var1, Value var2);

    public Value max(Value var1, Value var2);

    public Value isLt(Value var1, Value var2);

    public Value isGt(Value var1, Value var2);

    public Value isLe(Value var1, Value var2);

    public Value isGe(Value var1, Value var2);

    public Value rol(Value var1, Value var2);

    public Value ror(Value var1, Value var2);

    public Value cmp(Value var1, Value var2);

    public Value cmpG(Value var1, Value var2);

    public Value cmpL(Value var1, Value var2);

    public Value notNull(Value var1);

    public Value negate(Value var1);

    public Value complement(Value var1);

    public Value byteSwap(Value var1);

    public Value bitReverse(Value var1);

    public Value countLeadingZeros(Value var1);

    public Value countTrailingZeros(Value var1);

    public Value populationCount(Value var1);

    public Value classOf(Value var1, Value var2);

    default public Value classOf(Value typeId) {
        return this.classOf(typeId, this.getLiteralFactory().literalOf(this.getTypeSystem().getUnsignedInteger8Type(), 0L));
    }

    default public Value classOf(ClassObjectType cot) {
        return this.classOf(this.getLiteralFactory().literalOfType(cot));
    }

    default public Value classOf(InterfaceObjectType iot) {
        return this.classOf(this.getLiteralFactory().literalOfType(iot));
    }

    default public Value classOf(PrimitiveArrayObjectType aot) {
        return this.classOf(this.getLiteralFactory().literalOfType(aot));
    }

    default public Value classOf(ReferenceArrayObjectType aot) {
        return this.classOf(this.getLiteralFactory().literalOfType(aot.getLeafElementType()), this.getLiteralFactory().literalOf(aot.getDimensionCount()));
    }

    default public Value classOf(ArrayObjectType aot) {
        Value value;
        if (aot instanceof PrimitiveArrayObjectType) {
            PrimitiveArrayObjectType pa = (PrimitiveArrayObjectType)aot;
            value = this.classOf(pa);
        } else {
            value = this.classOf((ReferenceArrayObjectType)aot);
        }
        return value;
    }

    default public Value classOf(PhysicalObjectType pot) {
        Value value;
        if (pot instanceof ClassObjectType) {
            ClassObjectType cot = (ClassObjectType)pot;
            value = this.classOf(cot);
        } else {
            value = this.classOf((ArrayObjectType)pot);
        }
        return value;
    }

    default public Value classOf(ObjectType ot) {
        Value value;
        if (ot instanceof PhysicalObjectType) {
            PhysicalObjectType pot = (PhysicalObjectType)ot;
            value = this.classOf(pot);
        } else {
            value = this.classOf((InterfaceObjectType)ot);
        }
        return value;
    }

    public Value truncate(Value var1, WordType var2);

    public Value extend(Value var1, WordType var2);

    public Value bitCast(Value var1, WordType var2);

    public Value valueConvert(Value var1, WordType var2);

    public Value decodeReference(Value var1, PointerType var2);

    default public Value decodeReference(Value refVal) {
        PointerType pointerType;
        ValueType valType = refVal.getType();
        if (valType instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)valType;
            pointerType = rt.getUpperBound().getPointer();
        } else {
            PointerType pt;
            pointerType = valType instanceof PointerType ? (pt = (PointerType)valType) : this.getTypeSystem().getVoidType().getPointer();
        }
        return this.decodeReference(refVal, pointerType);
    }

    public Value instanceOf(Value var1, ObjectType var2, int var3);

    default public Value instanceOf(Value input, ObjectType expectedType) {
        return this.instanceOf(input, expectedType, 0);
    }

    public Value instanceOf(Value var1, TypeDescriptor var2);

    public Value checkcast(Value var1, Value var2, Value var3, CheckCast.CastType var4, ObjectType var5);

    public Value checkcast(Value var1, TypeDescriptor var2);

    public Value deref(Value var1);

    public Value invokeDynamic(MethodMethodHandleConstant var1, List<Literal> var2, String var3, MethodDescriptor var4, List<Value> var5);

    public Value currentThread();

    public Value lookupVirtualMethod(Value var1, TypeDescriptor var2, String var3, MethodDescriptor var4);

    public Value lookupVirtualMethod(Value var1, InstanceMethodElement var2);

    public Value lookupInterfaceMethod(Value var1, TypeDescriptor var2, String var3, MethodDescriptor var4);

    public Value lookupInterfaceMethod(Value var1, InstanceMethodElement var2);

    public Value resolveStaticMethod(TypeDescriptor var1, String var2, MethodDescriptor var3);

    public Value resolveInstanceMethod(TypeDescriptor var1, String var2, MethodDescriptor var3);

    public Value resolveConstructor(TypeDescriptor var1, MethodDescriptor var2);

    public Value auto(Value var1);

    public Value memberOf(Value var1, CompoundType.Member var2);

    public Value memberOfUnion(Value var1, UnionType.Member var2);

    public Value elementOf(Value var1, Value var2);

    public Value offsetPointer(Value var1, Value var2);

    public Value pointerDifference(Value var1, Value var2);

    public Value byteOffsetPointer(Value var1, Value var2, ValueType var3);

    public Value resolveStaticField(TypeDescriptor var1, String var2, TypeDescriptor var3);

    public Value instanceFieldOf(Value var1, InstanceFieldElement var2);

    public Value instanceFieldOf(Value var1, TypeDescriptor var2, String var3, TypeDescriptor var4);

    public Value stackAllocate(ValueType var1, Value var2, Value var3);

    public Value new_(ClassObjectType var1, Value var2, Value var3, Value var4);

    public Value new_(ClassTypeDescriptor var1);

    public Value newArray(PrimitiveArrayObjectType var1, Value var2);

    public Value newArray(ArrayTypeDescriptor var1, Value var2);

    public Value newReferenceArray(ReferenceArrayObjectType var1, Value var2, Value var3, Value var4);

    public Value multiNewArray(ArrayObjectType var1, List<Value> var2);

    public Value multiNewArray(ArrayTypeDescriptor var1, List<Value> var2);

    default public Value load(Value pointer) {
        return this.load(pointer, AccessModes.SinglePlain);
    }

    public Value load(Value var1, ReadAccessMode var2);

    public Value loadLength(Value var1);

    public Value loadTypeId(Value var1);

    public Value readModifyWrite(Value var1, ReadModifyWrite.Op var2, Value var3, ReadAccessMode var4, WriteAccessMode var5);

    public Value cmpAndSwap(Value var1, Value var2, Value var3, ReadAccessMode var4, WriteAccessMode var5, CmpAndSwap.Strength var6);

    public Value vaArg(Value var1, ValueType var2);

    default public Node store(Value pointer, Value value) {
        return this.store(pointer, value, AccessModes.SinglePlain);
    }

    public Node store(Value var1, Value var2, WriteAccessMode var3);

    public Node initCheck(InitializerElement var1, Value var2);

    public Node initializeClass(Value var1);

    public Node fence(GlobalAccessMode var1);

    public Node monitorEnter(Value var1);

    public Node monitorExit(Value var1);

    public Value nullCheck(Value var1);

    public Value divisorCheck(Value var1);

    public Value call(Value var1, Value var2, List<Value> var3);

    default public Value call(Value targetPtr, List<Value> arguments) {
        return this.call(targetPtr, this.emptyVoid(), arguments);
    }

    public Value callNoSideEffects(Value var1, Value var2, List<Value> var3);

    default public Value callNoSideEffects(Value targetPtr, List<Value> arguments) {
        return this.callNoSideEffects(targetPtr, this.emptyVoid(), arguments);
    }

    public Node nop();

    public Node begin(BlockLabel var1);

    public <T> BasicBlock begin(BlockLabel var1, T var2, BiConsumer<T, BasicBlockBuilder> var3);

    default public BasicBlock begin(BlockLabel blockLabel, Consumer<BasicBlockBuilder> maker) {
        return this.begin(blockLabel, maker, Consumer::accept);
    }

    public Node reachable(Value var1);

    public Node safePoint();

    public BasicBlock callNoReturn(Value var1, Value var2, List<Value> var3);

    default public BasicBlock callNoReturn(Value targetPtr, List<Value> arguments) {
        return this.callNoReturn(targetPtr, this.emptyVoid(), arguments);
    }

    public BasicBlock invokeNoReturn(Value var1, Value var2, List<Value> var3, BlockLabel var4, Map<Slot, Value> var5);

    default public BasicBlock invokeNoReturn(Value targetPtr, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        return this.invokeNoReturn(targetPtr, this.emptyVoid(), arguments, catchLabel, targetArguments);
    }

    public BasicBlock tailCall(Value var1, Value var2, List<Value> var3);

    default public BasicBlock tailCall(Value targetPtr, List<Value> arguments) {
        return this.tailCall(targetPtr, this.emptyVoid(), arguments);
    }

    public Value invoke(Value var1, Value var2, List<Value> var3, BlockLabel var4, BlockLabel var5, Map<Slot, Value> var6);

    default public Value invoke(Value targetPtr, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        return this.invoke(targetPtr, this.emptyVoid(), arguments, catchLabel, resumeLabel, targetArguments);
    }

    public BasicBlock goto_(BlockLabel var1, Map<Slot, Value> var2);

    default public BasicBlock goto_(BlockLabel resumeLabel, Slot slot, Value argValue) {
        return this.goto_(resumeLabel, Map.of(slot, argValue));
    }

    public BasicBlock if_(Value var1, BlockLabel var2, BlockLabel var3, Map<Slot, Value> var4);

    default public BasicBlock return_() {
        return this.return_(this.emptyVoid());
    }

    public BasicBlock return_(Value var1);

    public BasicBlock unreachable();

    public BasicBlock throw_(Value var1);

    public BasicBlock switch_(Value var1, int[] var2, BlockLabel[] var3, BlockLabel var4, Map<Slot, Value> var5);

    public BasicBlock ret(Value var1, Map<Slot, Value> var2);

    public BlockEntry getBlockEntry();

    public BasicBlock getTerminatedBlock();

    public static BasicBlockBuilder simpleBuilder(ExecutableElement element) {
        return new SimpleBasicBlockBuilder(element);
    }

    public static interface FactoryContext {
        public static final FactoryContext EMPTY = new FactoryContext(){

            @Override
            public <T> T get(Class<T> clazz) {
                throw new NoSuchElementException();
            }

            @Override
            public boolean has(Class<?> clazz) {
                return false;
            }
        };

        public <T> T get(Class<T> var1);

        public boolean has(Class<?> var1);

        public static <T> FactoryContext withInfo(final FactoryContext delegate, final Class<T> clazz, final T info) {
            Assert.checkNotNullParam((String)"delegate", (Object)delegate);
            Assert.checkNotNullParam((String)"clazz", clazz);
            Assert.checkNotNullParam((String)"info", info);
            return new FactoryContext(){

                @Override
                public <T> T get(Class<T> clazz0) {
                    if (clazz0 == clazz) {
                        return clazz0.cast(info);
                    }
                    return delegate.get(clazz0);
                }

                @Override
                public boolean has(Class<?> clazz0) {
                    return clazz == clazz0 || delegate.has(clazz0);
                }
            };
        }
    }
}

