/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.Node;
import org.qbicc.graph.PinnedNode;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class BlockParameter
extends AbstractValue
implements PinnedNode {
    private final ValueType type;
    private final boolean nullable;
    private final BlockLabel blockLabel;
    private final Slot slot;

    BlockParameter(Node callSite, ExecutableElement element, int line, int bci, ValueType type, boolean nullable, BlockLabel blockLabel, Slot slot) {
        super(callSite, element, line, bci);
        this.type = type;
        this.nullable = nullable;
        this.blockLabel = blockLabel;
        this.slot = slot;
    }

    @Override
    int calcHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    String getNodeName() {
        return "BlockParameter";
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public ValueType getType() {
        return this.type;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public BlockLabel getPinnedBlockLabel() {
        return this.blockLabel;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public Set<Value> getPossibleValues() {
        LinkedHashSet<Value> possibleValues = new LinkedHashSet<Value>();
        this.getPossibleValues(possibleValues, new HashSet<BlockParameter>(), false);
        return possibleValues;
    }

    public Set<Value> getPossibleValuesIncludingParameters() {
        LinkedHashSet<Value> possibleValues = new LinkedHashSet<Value>();
        this.getPossibleValues(possibleValues, new HashSet<BlockParameter>(), true);
        return possibleValues;
    }

    public boolean isEntryParameter() {
        return this.getPinnedBlock() == this.getElement().getMethodBody().getEntryBlock();
    }

    public int getIndex() {
        return this.slot.getIndex();
    }

    private void getPossibleValues(Set<Value> current, Set<BlockParameter> visited, boolean includeParams) {
        if (visited.add(this)) {
            BasicBlock pinnedBlock = this.getPinnedBlock();
            Set<BasicBlock> incoming = pinnedBlock.getIncoming();
            if (incoming.isEmpty()) {
                current.add(this);
            } else {
                for (BasicBlock basicBlock : incoming) {
                    if (!basicBlock.isReachable()) continue;
                    Terminator t = basicBlock.getTerminator();
                    if (t.isImplicitOutboundArgument(this.slot, pinnedBlock)) {
                        current.add(this);
                        continue;
                    }
                    Value value = t.getOutboundArgument(this.slot);
                    if (value instanceof BlockParameter) {
                        BlockParameter bp = (BlockParameter)value;
                        if (includeParams) {
                            current.add(value);
                        }
                        bp.getPossibleValues(current, visited, includeParams);
                        continue;
                    }
                    current.add(value);
                }
            }
        }
    }

    public boolean possibleValuesAreNullable() {
        if (!this.nullable) {
            return false;
        }
        return this.possibleValuesAreNullable(new HashSet<BlockParameter>());
    }

    private boolean possibleValuesAreNullable(HashSet<BlockParameter> visited) {
        if (visited.add(this) && this.nullable) {
            BasicBlock pinnedBlock = this.getPinnedBlock();
            Set<BasicBlock> incoming = pinnedBlock.getIncoming();
            if (incoming.isEmpty()) {
                return true;
            }
            for (BasicBlock basicBlock : incoming) {
                BlockParameter bp;
                if (!basicBlock.isReachable()) continue;
                Terminator t = basicBlock.getTerminator();
                if (t.isImplicitOutboundArgument(this.slot, pinnedBlock)) {
                    return true;
                }
                Value value = t.getOutboundArgument(this.slot);
                if (!(value instanceof BlockParameter ? (bp = (BlockParameter)value).possibleValuesAreNullable(visited) : value.isNullable())) continue;
                return true;
            }
        }
        return false;
    }

    public StringBuilder appendQualifiedName(StringBuilder b) {
        BasicBlock pinnedBlock = this.getPinnedBlock();
        if (pinnedBlock == null) {
            b.append("??").append('.');
        } else if (pinnedBlock.getIndex() != 1) {
            pinnedBlock.toString(b).append('.');
        }
        return b.append(this.slot);
    }

    @Override
    public StringBuilder toReferenceString(StringBuilder b) {
        return this.toLValueString(b);
    }

    @Override
    StringBuilder toLValueString(StringBuilder b) {
        return this.appendQualifiedName(b.append('%'));
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        if (this.nullable) {
            b.append("nullable ");
        }
        b.append("parameter ");
        this.type.toString(b);
        return b;
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

