/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.List;
import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.InvocationNode;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Call
extends AbstractValue
implements OrderedNode,
InvocationNode {
    private final Node dependency;
    private final Value target;
    private final Value receiver;
    private final List<Value> arguments;

    Call(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value target, Value receiver, List<Value> arguments) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.target = target;
        this.receiver = receiver;
        this.arguments = arguments;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(Call.class, this.dependency, this.target, this.receiver, this.arguments);
    }

    @Override
    String getNodeName() {
        return "Call";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Call && this.equals((Call)other);
    }

    public boolean equals(Call other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.target.equals(other.target) && this.receiver.equals(other.receiver) && this.arguments.equals(other.arguments);
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        return InvocationNode.toRValueString(this, "call", b);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return !this.target.isNoSafePoints();
    }

    @Override
    public Value getTarget() {
        return this.target;
    }

    @Override
    public Value getReceiver() {
        return this.receiver;
    }

    @Override
    public ValueType getType() {
        return this.getCalleeType().getReturnType();
    }

    @Override
    public List<Value> getArguments() {
        return this.arguments;
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

