/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import io.smallrye.common.constraint.Assert;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.NullLiteral;
import org.qbicc.type.CompoundType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class CmpAndSwap
extends AbstractValue
implements OrderedNode {
    private static final AttachmentKey<Map<ValueType, CompoundType>> RESULT_TYPE_MAP_KEY = new AttachmentKey();
    private final Node dependency;
    private final Value pointer;
    private final Value expectedValue;
    private final Value updateValue;
    private final CompoundType resultType;
    private final ReadAccessMode readAccessMode;
    private final WriteAccessMode writeAccessMode;
    private final Strength strength;

    CmpAndSwap(Node callSite, ExecutableElement element, int line, int bci, CompoundType resultType, Node dependency, Value pointer, Value expectedValue, Value updateValue, ReadAccessMode readAccessMode, WriteAccessMode writeAccessMode, Strength strength) {
        super(callSite, element, line, bci);
        this.resultType = (CompoundType)Assert.checkNotNullParam((String)"resultType", (Object)resultType);
        this.dependency = (Node)Assert.checkNotNullParam((String)"dependency", (Object)dependency);
        this.pointer = (Value)Assert.checkNotNullParam((String)"pointer", (Object)pointer);
        this.expectedValue = (Value)Assert.checkNotNullParam((String)"expectedValue", (Object)expectedValue);
        this.updateValue = (Value)Assert.checkNotNullParam((String)"updateValue", (Object)updateValue);
        this.readAccessMode = (ReadAccessMode)Assert.checkNotNullParam((String)"readAccessMode", (Object)readAccessMode);
        this.writeAccessMode = (WriteAccessMode)Assert.checkNotNullParam((String)"writeAccessMode", (Object)writeAccessMode);
        this.strength = (Strength)((Object)Assert.checkNotNullParam((String)"strength", (Object)((Object)strength)));
        if (!pointer.isWritable()) {
            throw new IllegalArgumentException("Handle is not writable");
        }
        if (!pointer.isReadable()) {
            throw new IllegalArgumentException("Handle is not readable");
        }
        ValueType targetType = pointer.getPointeeType();
        if (!(expectedValue instanceof NullLiteral) && !targetType.isImplicitlyConvertibleFrom(expectedValue.getType())) {
            throw new IllegalArgumentException("The target and expected value types must agree.");
        }
        if (!(updateValue instanceof NullLiteral) && !targetType.isImplicitlyConvertibleFrom(updateValue.getType())) {
            throw new IllegalArgumentException("The target and update value types must agree.");
        }
    }

    @Override
    int calcHashCode() {
        return Objects.hash(CmpAndSwap.class, this.dependency, this.pointer, this.expectedValue, this.updateValue, this.resultType, this.readAccessMode, this.writeAccessMode);
    }

    @Override
    String getNodeName() {
        return "CmpAndSwap";
    }

    @Override
    public CompoundType getType() {
        return this.resultType;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    public Value getPointer() {
        return this.pointer;
    }

    public Value getExpectedValue() {
        return this.expectedValue;
    }

    public Value getUpdateValue() {
        return this.updateValue;
    }

    public ReadAccessMode getReadAccessMode() {
        return this.readAccessMode;
    }

    public WriteAccessMode getWriteAccessMode() {
        return this.writeAccessMode;
    }

    public Strength getStrength() {
        return this.strength;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof CmpAndSwap && this.equals((CmpAndSwap)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.expectedValue.toReferenceString(b);
        b.append(',');
        this.updateValue.toReferenceString(b);
        b.append(',');
        b.append((Object)this.strength);
        b.append(',');
        b.append(this.readAccessMode);
        b.append(',');
        b.append(this.writeAccessMode);
        b.append(')');
        return b;
    }

    public boolean equals(CmpAndSwap other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.pointer.equals(other.pointer) && this.expectedValue.equals(other.expectedValue) && this.updateValue.equals(other.updateValue) && this.resultType.equals(other.resultType) && this.readAccessMode == other.readAccessMode && this.writeAccessMode == other.writeAccessMode && this.strength == other.strength;
    }

    @Override
    public int getValueDependencyCount() {
        return 3;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> this.pointer;
            case 1 -> this.expectedValue;
            case 2 -> this.updateValue;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public static CompoundType getResultType(CompilationContext ctxt, ValueType valueType) {
        TypeSystem ts;
        CompoundType appearing;
        CompoundType compoundType;
        Map<ValueType, CompoundType> appearing2;
        Map<ValueType, CompoundType> map = ctxt.getAttachment(RESULT_TYPE_MAP_KEY);
        if (map == null && (appearing2 = ctxt.putAttachmentIfAbsent(RESULT_TYPE_MAP_KEY, map = new ConcurrentHashMap<ValueType, CompoundType>())) != null) {
            map = appearing2;
        }
        if ((compoundType = map.get(valueType)) == null && (appearing = map.putIfAbsent(valueType, compoundType = CompoundType.builder(ts = ctxt.getTypeSystem()).setTag(CompoundType.Tag.NONE).setName(null).addNextMember(valueType).addNextMember(ts.getBooleanType()).setOverallAlignment(1).build())) != null) {
            compoundType = appearing;
        }
        return compoundType;
    }

    public CompoundType.Member getResultValueType() {
        return this.resultType.getMember(0);
    }

    public CompoundType.Member getResultFlagType() {
        return this.resultType.getMember(1);
    }

    public static enum Strength {
        WEAK,
        STRONG;

    }
}

