/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractNode;
import org.qbicc.graph.Action;
import org.qbicc.graph.ActionVisitor;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.LocalVariableElement;

public final class DebugAddressDeclaration
extends AbstractNode
implements Action,
OrderedNode {
    private final Node dependency;
    private final LocalVariableElement variable;
    private final Value address;

    DebugAddressDeclaration(Node callSite, ExecutableElement element, int line, int bci, Node dependency, LocalVariableElement variable, Value address) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.variable = variable;
        this.address = address;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    public LocalVariableElement getVariable() {
        return this.variable;
    }

    public Value getAddress() {
        return this.address;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.dependency, this.variable, this.address);
    }

    @Override
    String getNodeName() {
        return "DebugAddress";
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.address : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof DebugAddressDeclaration && this.equals((DebugAddressDeclaration)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.address.getPointeeType().toString(b);
        b.append(' ');
        b.append(this.variable.getName());
        b.append(')');
        b.append('@');
        this.address.toReferenceString(b);
        return b;
    }

    public boolean equals(DebugAddressDeclaration other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.variable.equals(other.variable) && this.address.equals(other.address);
    }

    @Override
    public <T, R> R accept(ActionVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

