/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;

public final class ExtractInstanceField
extends AbstractValue {
    private final Value objectValue;
    private final PhysicalObjectType objectType;
    private final FieldElement fieldElement;
    private final ValueType valueType;

    ExtractInstanceField(Node callSite, ExecutableElement element, int line, int bci, Value objectValue, FieldElement fieldElement, ValueType valueType) {
        super(callSite, element, line, bci);
        this.objectValue = objectValue;
        this.objectType = (PhysicalObjectType)objectValue.getType();
        this.fieldElement = fieldElement;
        this.valueType = valueType;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.objectValue, this.fieldElement);
    }

    @Override
    String getNodeName() {
        return "ExtractInstanceField";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ExtractInstanceField && this.equals((ExtractInstanceField)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.objectValue.toReferenceString(b);
        b.append(',');
        b.append(this.fieldElement);
        b.append(')');
        return b;
    }

    public boolean equals(ExtractInstanceField other) {
        return this == other || other != null && this.objectValue.equals(other.objectValue) && this.fieldElement.equals(other.fieldElement);
    }

    public PhysicalObjectType getObjectType() {
        return this.objectType;
    }

    public Value getObjectValue() {
        return this.objectValue;
    }

    @Override
    public ValueType getType() {
        return this.valueType;
    }

    public FieldElement getFieldElement() {
        return this.fieldElement;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.objectValue : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

