/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Map;
import java.util.Objects;
import org.qbicc.graph.AbstractTerminator;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.Node;
import org.qbicc.graph.Resume;
import org.qbicc.graph.Slot;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Goto
extends AbstractTerminator
implements Resume {
    private final Node dependency;
    private final BlockLabel targetLabel;
    private final BasicBlock terminatedBlock;

    Goto(Node callSite, ExecutableElement element, int line, int bci, BlockEntry blockEntry, Node dependency, BlockLabel targetLabel, Map<Slot, Value> targetArguments) {
        super(callSite, element, line, bci, targetArguments);
        this.terminatedBlock = new BasicBlock(blockEntry, this);
        this.dependency = dependency;
        this.targetLabel = targetLabel;
    }

    @Override
    public BasicBlock getTerminatedBlock() {
        return this.terminatedBlock;
    }

    @Override
    public BlockLabel getResumeTargetLabel() {
        return this.targetLabel;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public int getSuccessorCount() {
        return 1;
    }

    @Override
    public BasicBlock getSuccessor(int index) {
        return index == 0 ? this.getResumeTarget() : (BasicBlock)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public <T, R> R accept(TerminatorVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    int calcHashCode() {
        return Objects.hash(Goto.class, this.dependency, this.targetLabel);
    }

    @Override
    String getNodeName() {
        return "Goto";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Goto && this.equals((Goto)other);
    }

    public boolean equals(Goto other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.targetLabel.equals(other.targetLabel);
    }
}

