/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractNode;
import org.qbicc.graph.Action;
import org.qbicc.graph.ActionVisitor;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.InitializerElement;

public class InitCheck
extends AbstractNode
implements Action,
OrderedNode {
    private final Node dependency;
    private final InitializerElement initializerElement;
    private final Value initThunk;

    InitCheck(Node callSite, ExecutableElement element, int line, int bci, Node dependency, InitializerElement initializerElement, Value initThunk) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.initializerElement = initializerElement;
        this.initThunk = initThunk;
    }

    public InitializerElement getInitializerElement() {
        return this.initializerElement;
    }

    public Value getInitThunk() {
        return this.initThunk;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.initThunk : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    int calcHashCode() {
        return Objects.hash(InitCheck.class, this.dependency, this.initializerElement, this.initThunk);
    }

    @Override
    String getNodeName() {
        return "InitCheck";
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        InitCheck ic;
        return other instanceof InitCheck && this.equals(ic = (InitCheck)other);
    }

    public boolean equals(InitCheck other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.initializerElement.equals(other.initializerElement) && this.initThunk.equals(other.initThunk);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        b.append(this.initializerElement);
        b.append(',');
        this.initThunk.toReferenceString(b);
        b.append(')');
        return b;
    }

    @Override
    public <T, R> R accept(ActionVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

