/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.PointerType;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.InstanceFieldElement;

public final class InstanceFieldOf
extends AbstractValue {
    private final Value instancePointer;
    private final InstanceFieldElement field;
    private final PointerType type;

    InstanceFieldOf(Node callSite, ExecutableElement element, int line, int bci, Value instancePointer, InstanceFieldElement field) {
        super(callSite, element, line, bci);
        this.instancePointer = instancePointer;
        instancePointer.getType(PointerType.class);
        this.field = field;
        this.type = field.getType().getPointer();
    }

    public Value getInstance() {
        return this.instancePointer;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(index);
            }
        }
        return this.instancePointer;
    }

    @Override
    public PointerType getType() {
        return this.type;
    }

    public InstanceFieldElement getVariableElement() {
        return this.field;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.instancePointer, this.field);
    }

    @Override
    String getNodeName() {
        return "InstanceFieldOf";
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        b.append("field pointer ");
        this.instancePointer.toReferenceString(b);
        b.append('.');
        b.append(this.field.getName());
        return b;
    }

    @Override
    public boolean equals(Object other) {
        InstanceFieldOf ifo;
        return other instanceof InstanceFieldOf && this.equals(ifo = (InstanceFieldOf)other);
    }

    public boolean equals(InstanceFieldOf other) {
        return this == other || other != null && this.getVariableElement().equals(other.getVariableElement()) && this.instancePointer.equals(other.instancePointer);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

