/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Iterator;
import java.util.List;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.type.InvokableType;
import org.qbicc.type.PointerType;
import org.qbicc.type.VoidType;

public interface InvocationNode
extends Node {
    public Value getTarget();

    public Value getReceiver();

    default public boolean isVoidCall() {
        return this.getTarget().getReturnType() instanceof VoidType;
    }

    public List<Value> getArguments();

    @Override
    default public int getValueDependencyCount() {
        return this.getArguments().size() + 2;
    }

    @Override
    default public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> this.getTarget();
            case 1 -> this.getReceiver();
            default -> this.getArguments().get(index - 2);
        };
    }

    default public InvokableType getCalleeType() {
        return this.getTarget().getType(PointerType.class).getPointeeType(InvokableType.class);
    }

    public static StringBuilder toRValueString(InvocationNode node, String label, StringBuilder b) {
        Value receiver = node.getReceiver();
        if (!(receiver.getType() instanceof VoidType)) {
            receiver.toReferenceString(b).append("::");
        }
        Value target = node.getTarget();
        target.toReferenceString(b.append(label).append(' '));
        List<Value> arguments = node.getArguments();
        b.append('(');
        Iterator<Value> iter = arguments.iterator();
        if (iter.hasNext()) {
            iter.next().toReferenceString(b);
            while (iter.hasNext()) {
                iter.next().toReferenceString(b.append(',').append(' '));
            }
        }
        b.append(')');
        if (target.isNoSafePoints()) {
            b.append(" no-safepoints");
        }
        if (target.isNoThrow()) {
            b.append(" no-throw");
        }
        return b;
    }
}

