/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.type.PointerType;
import org.qbicc.type.UnionType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class MemberOfUnion
extends AbstractValue {
    private final Value unionPointer;
    private final PointerType pointerType;
    private final UnionType.Member member;

    MemberOfUnion(Node callSite, ExecutableElement element, int line, int bci, Value unionPointer, UnionType.Member member) {
        super(callSite, element, line, bci);
        this.unionPointer = unionPointer;
        this.member = member;
        this.pointerType = member.getType().getPointer().withQualifiersFrom(unionPointer.getType(PointerType.class));
    }

    public UnionType getUnionType() {
        return this.getUnionPointer().getType(PointerType.class).getPointeeType(UnionType.class);
    }

    @Override
    public PointerType getType() {
        return this.pointerType;
    }

    @Override
    public boolean isConstant() {
        return this.unionPointer.isConstant();
    }

    @Override
    public boolean isPointeeConstant() {
        return this.unionPointer.isPointeeConstant();
    }

    @Override
    public AccessMode getDetectedMode() {
        return this.unionPointer.getDetectedMode();
    }

    public UnionType.Member getMember() {
        return this.member;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(index);
            }
        }
        return this.unionPointer;
    }

    public Value getUnionPointer() {
        return this.unionPointer;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.unionPointer, this.member);
    }

    @Override
    String getNodeName() {
        return "MemberOfUnion";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof MemberOfUnion && this.equals((MemberOfUnion)other);
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        b.append("union member pointer ");
        this.unionPointer.toReferenceString(b);
        b.append('.');
        this.member.toString(b);
        return b;
    }

    public boolean equals(MemberOfUnion other) {
        return this == other || other != null && this.unionPointer.equals(other.unionPointer) && this.member.equals(other.member);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

