/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class NewReferenceArray
extends AbstractValue
implements OrderedNode {
    private final Node dependency;
    private final ReferenceArrayObjectType type;
    private final Value elemTypeId;
    private final Value dimensions;
    private final Value size;

    NewReferenceArray(Node callSite, ExecutableElement element, int line, int bci, Node dependency, ReferenceArrayObjectType type, Value elemTypeId, Value dimensions, Value size) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.type = type;
        this.elemTypeId = elemTypeId;
        this.dimensions = dimensions;
        this.size = size;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return true;
    }

    @Override
    public ReferenceType getType() {
        return this.type.getReference();
    }

    public Value getElemTypeId() {
        return this.elemTypeId;
    }

    public Value getDimensions() {
        return this.dimensions;
    }

    public Value getSize() {
        return this.size;
    }

    public ValueType getElementType() {
        return this.type.getElementType();
    }

    public ReferenceArrayObjectType getArrayType() {
        return this.type;
    }

    @Override
    public int getValueDependencyCount() {
        return 3;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                return this.elemTypeId;
            }
            case 1: {
                return this.dimensions;
            }
            case 2: {
                return this.size;
            }
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    int calcHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    String getNodeName() {
        return "NewReferenceArray";
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.type.toString(b);
        b.append(',');
        this.elemTypeId.toReferenceString(b);
        b.append(',');
        this.dimensions.toReferenceString(b);
        b.append(',');
        this.size.toReferenceString(b);
        b.append(')');
        return b;
    }

    @Override
    public boolean isNullable() {
        return false;
    }
}

