/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Action;
import org.qbicc.graph.Add;
import org.qbicc.graph.And;
import org.qbicc.graph.Auto;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BitCast;
import org.qbicc.graph.BitReverse;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.ByteOffsetPointer;
import org.qbicc.graph.ByteSwap;
import org.qbicc.graph.Call;
import org.qbicc.graph.CallNoReturn;
import org.qbicc.graph.CallNoSideEffects;
import org.qbicc.graph.CheckCast;
import org.qbicc.graph.ClassOf;
import org.qbicc.graph.Cmp;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.CmpG;
import org.qbicc.graph.CmpL;
import org.qbicc.graph.Comp;
import org.qbicc.graph.Convert;
import org.qbicc.graph.CountLeadingZeros;
import org.qbicc.graph.CountTrailingZeros;
import org.qbicc.graph.CurrentThread;
import org.qbicc.graph.DebugAddressDeclaration;
import org.qbicc.graph.DebugValueDeclaration;
import org.qbicc.graph.DecodeReference;
import org.qbicc.graph.Dereference;
import org.qbicc.graph.Div;
import org.qbicc.graph.ElementOf;
import org.qbicc.graph.Extend;
import org.qbicc.graph.ExtractElement;
import org.qbicc.graph.ExtractInstanceField;
import org.qbicc.graph.ExtractMember;
import org.qbicc.graph.Fence;
import org.qbicc.graph.Goto;
import org.qbicc.graph.If;
import org.qbicc.graph.InitCheck;
import org.qbicc.graph.InitializeClass;
import org.qbicc.graph.InsertElement;
import org.qbicc.graph.InsertMember;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.InstanceOf;
import org.qbicc.graph.InterfaceMethodLookup;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.InvokeNoReturn;
import org.qbicc.graph.IsEq;
import org.qbicc.graph.IsGe;
import org.qbicc.graph.IsGt;
import org.qbicc.graph.IsLe;
import org.qbicc.graph.IsLt;
import org.qbicc.graph.IsNe;
import org.qbicc.graph.Load;
import org.qbicc.graph.Max;
import org.qbicc.graph.MemberOf;
import org.qbicc.graph.MemberOfUnion;
import org.qbicc.graph.Min;
import org.qbicc.graph.Mod;
import org.qbicc.graph.MonitorEnter;
import org.qbicc.graph.MonitorExit;
import org.qbicc.graph.MultiNewArray;
import org.qbicc.graph.Multiply;
import org.qbicc.graph.Neg;
import org.qbicc.graph.New;
import org.qbicc.graph.NewArray;
import org.qbicc.graph.NewReferenceArray;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.NotNull;
import org.qbicc.graph.OffsetOfField;
import org.qbicc.graph.OffsetPointer;
import org.qbicc.graph.Or;
import org.qbicc.graph.PointerDifference;
import org.qbicc.graph.PopCount;
import org.qbicc.graph.Reachable;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Ret;
import org.qbicc.graph.Return;
import org.qbicc.graph.Rol;
import org.qbicc.graph.Ror;
import org.qbicc.graph.SafePoint;
import org.qbicc.graph.Select;
import org.qbicc.graph.Shl;
import org.qbicc.graph.Shr;
import org.qbicc.graph.Slot;
import org.qbicc.graph.StackAllocation;
import org.qbicc.graph.Store;
import org.qbicc.graph.Sub;
import org.qbicc.graph.Switch;
import org.qbicc.graph.TailCall;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.Throw;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.Unreachable;
import org.qbicc.graph.Unschedulable;
import org.qbicc.graph.VaArg;
import org.qbicc.graph.Value;
import org.qbicc.graph.VirtualMethodLookup;
import org.qbicc.graph.Xor;
import org.qbicc.graph.literal.ArrayLiteral;
import org.qbicc.graph.literal.BitCastLiteral;
import org.qbicc.graph.literal.BlockLiteral;
import org.qbicc.graph.literal.CompoundLiteral;
import org.qbicc.graph.literal.ElementOfLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.MemberOfLiteral;
import org.qbicc.graph.literal.OffsetFromLiteral;
import org.qbicc.graph.literal.ValueConvertLiteral;
import org.qbicc.graph.schedule.Util;
import org.qbicc.type.CompoundType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;

public interface Node {
    public Node getCallSite();

    public ExecutableElement getElement();

    public int getSourceLine();

    public int getBytecodeIndex();

    public int getScheduleIndex();

    public void setScheduleIndex(int var1);

    public BasicBlock getScheduledBlock();

    public void setScheduledBlock(BasicBlock var1);

    public Set<Value> getLiveIns();

    public void setLiveIns(Set<Value> var1);

    public Set<Value> getLiveOuts();

    public void setLiveOuts(Set<Value> var1);

    default public int getValueDependencyCount() {
        return 0;
    }

    default public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(index);
    }

    public StringBuilder toString(StringBuilder var1);

    default public int getBlockIndex() {
        return this.getScheduledBlock().getIndex();
    }

    public static final class Copier {
        private final BasicBlock entryBlock;
        private final BasicBlockBuilder blockBuilder;
        private final NodeVisitor<Copier, Value, Node, BasicBlock> nodeVisitor;
        private final Map<BasicBlock, BlockLabel> copiedBlocks = new HashMap<BasicBlock, BlockLabel>();
        private final HashMap<Node, Node> copiedNodes = new HashMap();
        private final HashMap<Terminator, BasicBlock> copiedTerminators = new HashMap();
        private final Queue<BasicBlock> blockQueue = new ArrayDeque<BasicBlock>();
        private final Terminus terminus = new Terminus();
        private final CompilationContext ctxt;
        private final Map<Set<Value>, Set<Value>> cache = new HashMap<Set<Value>, Set<Value>>();
        private Set<Value> liveOut;
        private Set<Value> liveIn;

        public Copier(BasicBlock entryBlock, BasicBlockBuilder builder, CompilationContext ctxt, BiFunction<CompilationContext, NodeVisitor<Copier, Value, Node, BasicBlock>, NodeVisitor<Copier, Value, Node, BasicBlock>> nodeVisitorFactory) {
            this.entryBlock = entryBlock;
            this.ctxt = ctxt;
            this.blockBuilder = builder;
            this.nodeVisitor = nodeVisitorFactory.apply(ctxt, this.terminus);
        }

        public static BasicBlock execute(BasicBlock entryBlock, BasicBlockBuilder builder, CompilationContext param, BiFunction<CompilationContext, NodeVisitor<Copier, Value, Node, BasicBlock>, NodeVisitor<Copier, Value, Node, BasicBlock>> nodeVisitorFactory) {
            return new Copier(entryBlock, builder, param, nodeVisitorFactory).copyProgram();
        }

        public BasicBlockBuilder getBlockBuilder() {
            return this.blockBuilder;
        }

        public BasicBlock copyProgram() {
            BasicBlock block;
            BlockLabel entryCopy = this.copyBlock(this.entryBlock);
            while ((block = this.blockQueue.poll()) != null) {
                this.blockBuilder.begin(this.copiedBlocks.get(block));
                this.copyScheduledNodes(block);
            }
            return BlockLabel.getTargetOf(entryCopy);
        }

        public BlockLabel copyBlock(BasicBlock original) {
            BlockLabel copy = this.copiedBlocks.get(original);
            if (copy == null) {
                copy = new BlockLabel();
                this.copiedBlocks.put(original, copy);
                this.blockQueue.add(original);
            }
            return copy;
        }

        public void copyBlockAs(BasicBlock original, BlockLabel copy) {
            if (this.copiedBlocks.putIfAbsent(original, copy) != null) {
                throw new IllegalStateException();
            }
        }

        public void copyScheduledNodes(BasicBlock block) {
            try {
                List<Node> instructions = block.getInstructions();
                this.mapInstructions(block, instructions.listIterator(instructions.size()), new HashSet<Value>(block.getLiveOuts()), block.getLiveOuts());
            }
            catch (BlockEarlyTermination term) {
                this.copiedTerminators.put(block.getTerminator(), term.getTerminatedBlock());
            }
        }

        private void mapInstructions(BasicBlock block, ListIterator<Node> iter, Set<Value> live, Set<Value> liveOuts) {
            BlockParameter bp;
            if (!iter.hasPrevious()) {
                return;
            }
            Node node = iter.previous();
            if (!(node instanceof BlockParameter) || (bp = (BlockParameter)node).getPinnedBlock() == block) {
                // empty if block
            }
            if (node instanceof Value) {
                Value v = (Value)node;
                live.remove(v);
            } else if (node instanceof Invoke) {
                Invoke inv = (Invoke)node;
                live.remove(inv.getReturnValue());
            }
            int cnt = node.getValueDependencyCount();
            for (int i = 0; i < cnt; ++i) {
                Value val = node.getValueDependency(i);
                if (!(val.getType() instanceof ReferenceType) || val instanceof Literal) continue;
                live.add(val);
            }
            Set<Value> liveIn = Util.getCachedSet(this.cache, live);
            this.mapInstructions(block, iter, live, liveIn);
            this.liveIn = liveIn;
            this.liveOut = liveOuts;
            this.copyNode(node);
        }

        public Set<Value> getLiveIn() {
            return this.liveIn;
        }

        public Set<Value> getLiveOut() {
            return this.liveOut;
        }

        public Node copyNode(Node original) {
            if (original instanceof Value) {
                return this.copyValue((Value)original);
            }
            if (original instanceof Action) {
                return this.copyAction((Action)original);
            }
            assert (original instanceof Terminator);
            BasicBlock block = this.copyTerminator((Terminator)original);
            return block.getTerminator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Value copyValue(Value original) {
            Value copy = (Value)this.copiedNodes.get(original);
            if (copy == null) {
                if (!(original instanceof Unschedulable) && original.getScheduledBlock() == null) {
                    this.blockBuilder.getContext().warning((Element)this.blockBuilder.getCurrentElement(), "Converting unscheduled node %s to unreachable()", original.toString());
                    throw new BlockEarlyTermination(this.blockBuilder.unreachable());
                }
                if (original instanceof Literal) {
                    Literal lit = (Literal)original;
                    copy = (Value)lit.accept(this.nodeVisitor, this);
                    this.copiedNodes.put(original, copy);
                    return copy;
                }
                int oldLine = this.blockBuilder.setLineNumber(original.getSourceLine());
                int oldBci = this.blockBuilder.setBytecodeIndex(original.getBytecodeIndex());
                ExecutableElement oldElement = this.blockBuilder.setCurrentElement(original.getElement());
                Node origCallSite = original.getCallSite();
                Node oldCallSite = origCallSite == null ? this.blockBuilder.getCallSite() : this.blockBuilder.setCallSite(this.copyNode(origCallSite));
                try {
                    copy = (Value)original.accept(this.nodeVisitor, this);
                    this.copiedNodes.put(original, copy);
                }
                finally {
                    this.blockBuilder.setLineNumber(oldLine);
                    this.blockBuilder.setBytecodeIndex(oldBci);
                    this.blockBuilder.setCurrentElement(oldElement);
                    this.blockBuilder.setCallSite(oldCallSite);
                }
            }
            return copy;
        }

        public List<Value> copyValues(List<Value> list) {
            if (list.isEmpty()) {
                return List.of();
            }
            Value[] values = new Value[list.size()];
            int i = 0;
            for (Value original : list) {
                values[i++] = this.copyValue(original);
            }
            return Arrays.asList(values);
        }

        public List<Literal> copyLiterals(List<Literal> list) {
            if (list.isEmpty()) {
                return List.of();
            }
            Literal[] values = new Literal[list.size()];
            int i = 0;
            for (Literal original : list) {
                values[i++] = (Literal)this.copyValue(original);
            }
            return Arrays.asList(values);
        }

        public Map<Slot, Value> copyArguments(Terminator terminator) {
            Set<Slot> names = terminator.getOutboundArgumentNames();
            if (names.isEmpty()) {
                return Map.of();
            }
            ImmutableMap copy = Maps.immutable.empty();
            block0: for (Slot slot : names) {
                int cnt = terminator.getSuccessorCount();
                for (int i = 0; i < cnt; ++i) {
                    if (terminator.getSuccessor(i).getBlockParameter(slot) == null) continue;
                    copy = copy.newWithKeyValue((Object)slot, (Object)this.copyValue(terminator.getOutboundArgument(slot)));
                    continue block0;
                }
            }
            return copy.castToMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Node copyAction(Action original) {
            Node copy = this.copiedNodes.get(original);
            if (copy == null) {
                if (!(original instanceof Unschedulable) && original.getScheduledBlock() == null) {
                    throw new IllegalStateException("Missing schedule for node");
                }
                int oldLine = this.blockBuilder.setLineNumber(original.getSourceLine());
                int oldBci = this.blockBuilder.setBytecodeIndex(original.getBytecodeIndex());
                ExecutableElement oldElement = this.blockBuilder.setCurrentElement(original.getElement());
                Node origCallSite = original.getCallSite();
                Node oldCallSite = origCallSite == null ? this.blockBuilder.getCallSite() : this.blockBuilder.setCallSite(this.copyNode(origCallSite));
                try {
                    copy = (Node)original.accept(this.nodeVisitor, this);
                    this.copiedNodes.put(original, copy);
                }
                finally {
                    this.blockBuilder.setLineNumber(oldLine);
                    this.blockBuilder.setBytecodeIndex(oldBci);
                    this.blockBuilder.setCurrentElement(oldElement);
                    this.blockBuilder.setCallSite(oldCallSite);
                }
            }
            return copy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BasicBlock copyTerminator(Terminator original) {
            BasicBlock basicBlock = this.copiedTerminators.get(original);
            if (basicBlock == null) {
                BasicBlock block;
                if (!(original instanceof Unschedulable) && original.getScheduledBlock() == null) {
                    throw new IllegalStateException("Missing schedule for node");
                }
                int oldLine = this.blockBuilder.setLineNumber(original.getSourceLine());
                int oldBci = this.blockBuilder.setBytecodeIndex(original.getBytecodeIndex());
                ExecutableElement oldElement = this.blockBuilder.setCurrentElement(original.getElement());
                Node origCallSite = original.getCallSite();
                Node oldCallSite = origCallSite == null ? this.blockBuilder.getCallSite() : this.blockBuilder.setCallSite(this.copyNode(origCallSite));
                try {
                    block = (BasicBlock)original.accept(this.nodeVisitor, this);
                }
                catch (BlockEarlyTermination term) {
                    block = term.getTerminatedBlock();
                }
                finally {
                    this.blockBuilder.setLineNumber(oldLine);
                    this.blockBuilder.setBytecodeIndex(oldBci);
                    this.blockBuilder.setCurrentElement(oldElement);
                    this.blockBuilder.setCallSite(oldCallSite);
                }
                this.copiedTerminators.put(original, block);
                return block;
            }
            return basicBlock;
        }

        static class Terminus
        implements NodeVisitor<Copier, Value, Node, BasicBlock> {
            Terminus() {
            }

            @Override
            public Node visitUnknown(Copier param, Action node) {
                throw Assert.unreachableCode();
            }

            @Override
            public BasicBlock visitUnknown(Copier param, Terminator node) {
                throw Assert.unreachableCode();
            }

            @Override
            public Value visitUnknown(Copier param, Value node) {
                throw Assert.unreachableCode();
            }

            @Override
            public Value visitAny(Copier copier, Literal literal) {
                Assert.assertTrue((literal.getValueDependencyCount() == 0 ? 1 : 0) != 0);
                return literal;
            }

            @Override
            public Value visit(Copier copier, ArrayLiteral literal) {
                List<Literal> values = copier.copyLiterals(literal.getValues());
                return copier.getBlockBuilder().getLiteralFactory().literalOf(literal.getType(), values);
            }

            @Override
            public Value visit(Copier copier, BitCastLiteral literal) {
                Literal value = (Literal)copier.copyValue(literal.getValue());
                if (value == literal.getValue()) {
                    return literal;
                }
                return copier.getBlockBuilder().getLiteralFactory().bitcastLiteral(value, literal.getType());
            }

            @Override
            public Value visit(Copier copier, CompoundLiteral literal) {
                Map<CompoundType.Member, Literal> old = literal.getValues();
                HashMap<CompoundType.Member, Literal> copied = new HashMap<CompoundType.Member, Literal>();
                for (Map.Entry<CompoundType.Member, Literal> e : old.entrySet()) {
                    copied.put(e.getKey(), (Literal)copier.copyValue(e.getValue()));
                }
                return copier.getBlockBuilder().getLiteralFactory().literalOf(literal.getType(), copied);
            }

            @Override
            public Value visit(Copier copier, ElementOfLiteral literal) {
                Literal arrayPointer = (Literal)copier.copyValue(literal.getArrayPointer());
                Literal index = (Literal)copier.copyValue(literal.getIndex());
                if (arrayPointer == literal.getArrayPointer() && index == literal.getIndex()) {
                    return literal;
                }
                return copier.getBlockBuilder().getLiteralFactory().elementOfLiteral(arrayPointer, index);
            }

            @Override
            public Value visit(Copier copier, OffsetFromLiteral literal) {
                Literal basePointer = (Literal)copier.copyValue(literal.getBasePointer());
                Literal offset = (Literal)copier.copyValue(literal.getOffset());
                if (basePointer == literal.getBasePointer() && offset == literal.getOffset()) {
                    return literal;
                }
                return copier.getBlockBuilder().getLiteralFactory().offsetFromLiteral(basePointer, offset);
            }

            @Override
            public Value visit(Copier copier, MemberOfLiteral literal) {
                Literal structPointer = (Literal)copier.copyValue(literal.getStructurePointer());
                if (structPointer == literal.getStructurePointer()) {
                    return literal;
                }
                return copier.getBlockBuilder().getLiteralFactory().memberOfLiteral(structPointer, literal.getMember());
            }

            @Override
            public Value visit(Copier copier, ValueConvertLiteral literal) {
                Literal value = (Literal)copier.copyValue(literal.getValue());
                if (value == literal.getValue()) {
                    return literal;
                }
                return copier.getBlockBuilder().getLiteralFactory().valueConvertLiteral(value, literal.getType());
            }

            @Override
            public Node visit(Copier param, BlockEntry node) {
                return param.getBlockBuilder().getBlockEntry();
            }

            @Override
            public Node visit(Copier param, MonitorEnter node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().monitorEnter(param.copyValue(node.getInstance()));
            }

            @Override
            public Node visit(Copier param, MonitorExit node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().monitorExit(param.copyValue(node.getInstance()));
            }

            @Override
            public Node visit(Copier copier, Reachable node) {
                copier.copyNode(node.getDependency());
                return copier.getBlockBuilder().reachable(copier.copyValue(node.getReachableValue()));
            }

            @Override
            public Node visit(Copier copier, SafePoint node) {
                copier.copyNode(node.getDependency());
                return copier.getBlockBuilder().safePoint();
            }

            @Override
            public Node visit(Copier param, InitCheck node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().initCheck(node.getInitializerElement(), param.copyValue(node.getInitThunk()));
            }

            @Override
            public Node visit(Copier copier, InitializeClass node) {
                copier.copyNode(node.getDependency());
                return copier.getBlockBuilder().initializeClass(copier.copyValue(node.getInitializeClassValue()));
            }

            @Override
            public Node visit(Copier param, DebugAddressDeclaration node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().declareDebugAddress(node.getVariable(), param.copyValue(node.getAddress()));
            }

            @Override
            public Node visit(Copier param, DebugValueDeclaration node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().setDebugValue(node.getVariable(), param.copyValue(node.getValue()));
            }

            @Override
            public Node visit(Copier param, Fence node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().fence(node.getAccessMode());
            }

            @Override
            public BasicBlock visit(Copier param, CallNoReturn node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().callNoReturn(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()));
            }

            @Override
            public BasicBlock visit(Copier param, Goto node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().goto_(param.copyBlock(node.getResumeTarget()), param.copyArguments(node));
            }

            @Override
            public BasicBlock visit(Copier param, If node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().if_(param.copyValue(node.getCondition()), param.copyBlock(node.getTrueBranch()), param.copyBlock(node.getFalseBranch()), param.copyArguments(node));
            }

            @Override
            public BasicBlock visit(Copier param, Invoke node) {
                Value invoke;
                param.copyNode(node.getDependency());
                try {
                    invoke = param.getBlockBuilder().invoke(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()), param.copyBlock(node.getCatchBlock()), param.copyBlock(node.getResumeTarget()), param.copyArguments(node));
                }
                catch (BlockEarlyTermination bet) {
                    param.copiedNodes.put(node.getReturnValue(), param.ctxt.getLiteralFactory().undefinedLiteralOfType(node.getReturnValue().getType()));
                    throw bet;
                }
                param.copiedNodes.put(node.getReturnValue(), invoke);
                return param.getBlockBuilder().getTerminatedBlock();
            }

            @Override
            public BasicBlock visit(Copier param, InvokeNoReturn node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().invokeNoReturn(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()), param.copyBlock(node.getCatchBlock()), param.copyArguments(node));
            }

            @Override
            public BasicBlock visit(Copier param, Ret node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().ret(param.copyValue(node.getReturnAddressValue()), param.copyArguments(node));
            }

            @Override
            public BasicBlock visit(Copier param, Switch node) {
                param.copyNode(node.getDependency());
                int cnt = node.getNumberOfValues();
                BlockLabel[] targetsCopy = new BlockLabel[cnt];
                for (int i = 0; i < cnt; ++i) {
                    targetsCopy[i] = param.copyBlock(node.getTargetForIndex(i));
                }
                return param.getBlockBuilder().switch_(param.copyValue(node.getSwitchValue()), node.getValues(), targetsCopy, param.copyBlock(node.getDefaultTarget()), param.copyArguments(node));
            }

            @Override
            public BasicBlock visit(Copier param, TailCall node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().tailCall(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()));
            }

            @Override
            public BasicBlock visit(Copier param, Throw node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().throw_(param.copyValue(node.getThrownValue()));
            }

            @Override
            public BasicBlock visit(Copier param, Unreachable node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().unreachable();
            }

            @Override
            public BasicBlock visit(Copier param, Return node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().return_(param.copyValue(node.getReturnValue()));
            }

            @Override
            public Value visit(Copier param, Add node) {
                return param.getBlockBuilder().add(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, And node) {
                return param.getBlockBuilder().and(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier copier, Auto node) {
                return node;
            }

            @Override
            public Value visit(Copier param, BitCast node) {
                return param.getBlockBuilder().bitCast(param.copyValue(node.getInput()), node.getType());
            }

            @Override
            public Value visit(Copier param, BitReverse node) {
                return param.getBlockBuilder().bitReverse(param.copyValue(node.getInput()));
            }

            @Override
            public Value visit(Copier param, BlockLiteral node) {
                return param.ctxt.getLiteralFactory().literalOf(param.copyBlock(BlockLabel.getTargetOf(node.getBlockLabel())));
            }

            @Override
            public Value visit(Copier copier, BlockParameter node) {
                return copier.getBlockBuilder().addParam(copier.copyBlock(node.getPinnedBlock()), node.getSlot(), node.getType(), node.possibleValuesAreNullable());
            }

            @Override
            public Value visit(Copier param, ByteSwap node) {
                return param.getBlockBuilder().byteSwap(param.copyValue(node.getInput()));
            }

            @Override
            public Value visit(Copier param, Call node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().call(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()));
            }

            @Override
            public Value visit(Copier param, CallNoSideEffects node) {
                return param.getBlockBuilder().callNoSideEffects(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()));
            }

            @Override
            public Value visit(Copier param, CheckCast node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().checkcast(param.copyValue(node.getInput()), param.copyValue(node.getToType()), param.copyValue(node.getToDimensions()), node.getKind(), node.getExpectedType());
            }

            @Override
            public Value visit(Copier param, ClassOf node) {
                return param.getBlockBuilder().classOf(param.copyValue(node.getInput()), param.copyValue(node.getDimensions()));
            }

            @Override
            public Value visit(Copier param, CountLeadingZeros node) {
                return param.getBlockBuilder().countLeadingZeros(param.copyValue(node.getInput()));
            }

            @Override
            public Value visit(Copier param, CountTrailingZeros node) {
                return param.getBlockBuilder().countTrailingZeros(param.copyValue(node.getInput()));
            }

            @Override
            public Value visit(Copier param, Cmp node) {
                return param.getBlockBuilder().cmp(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, CmpAndSwap node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().cmpAndSwap(param.copyValue(node.getPointer()), param.copyValue(node.getExpectedValue()), param.copyValue(node.getUpdateValue()), node.getReadAccessMode(), node.getWriteAccessMode(), node.getStrength());
            }

            @Override
            public Value visit(Copier param, CmpG node) {
                return param.getBlockBuilder().cmpG(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, CmpL node) {
                return param.getBlockBuilder().cmpL(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, Comp node) {
                return param.getBlockBuilder().complement(param.copyValue(node.getInput()));
            }

            @Override
            public Value visit(Copier param, CurrentThread node) {
                return param.getBlockBuilder().currentThread();
            }

            @Override
            public Value visit(Copier param, Convert node) {
                return param.getBlockBuilder().valueConvert(param.copyValue(node.getInput()), node.getType());
            }

            @Override
            public Value visit(Copier copier, DecodeReference node) {
                return copier.getBlockBuilder().decodeReference(copier.copyValue(node.getInput()), node.getType());
            }

            @Override
            public Value visit(Copier param, Div node) {
                return param.getBlockBuilder().divide(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier copier, ElementOf node) {
                return copier.getBlockBuilder().elementOf(copier.copyValue(node.getArrayPointer()), copier.copyValue(node.getIndex()));
            }

            @Override
            public Value visit(Copier param, Extend node) {
                return param.getBlockBuilder().extend(param.copyValue(node.getInput()), node.getType());
            }

            @Override
            public Value visit(Copier param, ExtractElement node) {
                return param.getBlockBuilder().extractElement(param.copyValue(node.getArrayValue()), param.copyValue(node.getIndex()));
            }

            @Override
            public Value visit(Copier param, ExtractInstanceField node) {
                return param.getBlockBuilder().extractInstanceField(param.copyValue(node.getObjectValue()), node.getFieldElement());
            }

            @Override
            public Value visit(Copier param, ExtractMember node) {
                return param.getBlockBuilder().extractMember(param.copyValue(node.getCompoundValue()), node.getMember());
            }

            @Override
            public Value visit(Copier param, InsertElement node) {
                return param.getBlockBuilder().insertElement(param.copyValue(node.getArrayValue()), param.copyValue(node.getIndex()), param.copyValue(node.getInsertedValue()));
            }

            @Override
            public Value visit(Copier param, InsertMember node) {
                return param.getBlockBuilder().insertMember(param.copyValue(node.getCompoundValue()), node.getMember(), param.copyValue(node.getInsertedValue()));
            }

            @Override
            public Value visit(Copier param, InstanceOf node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().instanceOf(param.copyValue(node.getInstance()), node.getCheckType(), node.getCheckDimensions());
            }

            @Override
            public Value visit(Copier copier, InterfaceMethodLookup node) {
                copier.copyNode(node.getDependency());
                return copier.getBlockBuilder().lookupInterfaceMethod(copier.copyValue(node.getReference()), node.getMethod());
            }

            @Override
            public Value visit(Copier param, IsEq node) {
                return param.getBlockBuilder().isEq(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, IsGe node) {
                return param.getBlockBuilder().isGe(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, IsGt node) {
                return param.getBlockBuilder().isGt(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, IsLe node) {
                return param.getBlockBuilder().isLe(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, IsLt node) {
                return param.getBlockBuilder().isLt(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, IsNe node) {
                return param.getBlockBuilder().isNe(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, InstanceFieldOf node) {
                return param.getBlockBuilder().instanceFieldOf(param.copyValue(node.getInstance()), node.getVariableElement());
            }

            @Override
            public Value visit(Copier param, Load node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().load(param.copyValue(node.getPointer()), node.getAccessMode());
            }

            @Override
            public Value visit(Copier param, MemberOf node) {
                return param.getBlockBuilder().memberOf(param.copyValue(node.getStructurePointer()), node.getMember());
            }

            @Override
            public Value visit(Copier copier, MemberOfUnion node) {
                return copier.getBlockBuilder().memberOfUnion(copier.copyValue(node.getUnionPointer()), node.getMember());
            }

            @Override
            public Value visit(Copier param, Max node) {
                return param.getBlockBuilder().max(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, Dereference node) {
                return param.getBlockBuilder().deref(param.copyValue(node.getPointer()));
            }

            @Override
            public Value visit(Copier param, Min node) {
                return param.getBlockBuilder().min(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, Mod node) {
                return param.getBlockBuilder().remainder(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, MultiNewArray node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().multiNewArray(node.getArrayType(), param.copyValues(node.getDimensions()));
            }

            @Override
            public Value visit(Copier param, Multiply node) {
                return param.getBlockBuilder().multiply(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, Neg node) {
                return param.getBlockBuilder().negate(param.copyValue(node.getInput()));
            }

            @Override
            public Value visit(Copier param, New node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().new_(node.getClassObjectType(), param.copyValue(node.getTypeId()), param.copyValue(node.getSize()), param.copyValue(node.getAlign()));
            }

            @Override
            public Value visit(Copier param, NewArray node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().newArray(node.getArrayType(), param.copyValue(node.getSize()));
            }

            @Override
            public Value visit(Copier param, NewReferenceArray node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().newReferenceArray(node.getArrayType(), param.copyValue(node.getElemTypeId()), param.copyValue(node.getDimensions()), param.copyValue(node.getSize()));
            }

            @Override
            public Value visit(Copier param, NotNull node) {
                return param.getBlockBuilder().notNull(param.copyValue(node.getInput()));
            }

            @Override
            public Value visit(Copier param, OffsetOfField node) {
                return param.getBlockBuilder().offsetOfField(node.getFieldElement());
            }

            @Override
            public Value visit(Copier copier, OffsetPointer node) {
                return copier.getBlockBuilder().offsetPointer(copier.copyValue(node.getBasePointer()), copier.copyValue(node.getOffset()));
            }

            @Override
            public Value visit(Copier param, Or node) {
                return param.getBlockBuilder().or(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier copier, PointerDifference node) {
                return copier.getBlockBuilder().pointerDifference(copier.copyValue(node.getLeftInput()), copier.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, PopCount node) {
                return param.getBlockBuilder().populationCount(param.copyValue(node.getInput()));
            }

            @Override
            public Value visit(Copier copier, ReadModifyWrite node) {
                return copier.getBlockBuilder().readModifyWrite(copier.copyValue(node.getPointer()), node.getOp(), copier.copyValue(node.getUpdateValue()), node.getReadAccessMode(), node.getWriteAccessMode());
            }

            @Override
            public Value visit(Copier param, Rol node) {
                return param.getBlockBuilder().rol(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, Ror node) {
                return param.getBlockBuilder().ror(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, Select node) {
                return param.getBlockBuilder().select(param.copyValue(node.getCondition()), param.copyValue(node.getTrueValue()), param.copyValue(node.getFalseValue()));
            }

            @Override
            public Value visit(Copier param, Shl node) {
                return param.getBlockBuilder().shl(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, Shr node) {
                return param.getBlockBuilder().shr(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, StackAllocation node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().stackAllocate(node.getType().getPointeeType(), param.copyValue(node.getCount()), param.copyValue(node.getAlign()));
            }

            @Override
            public Node visit(Copier param, Store node) {
                param.copyNode(node.getDependency());
                return param.getBlockBuilder().store(param.copyValue(node.getPointer()), param.copyValue(node.getValue()), node.getAccessMode());
            }

            @Override
            public Value visit(Copier param, Sub node) {
                return param.getBlockBuilder().sub(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }

            @Override
            public Value visit(Copier param, Truncate node) {
                return param.getBlockBuilder().truncate(param.copyValue(node.getInput()), node.getType());
            }

            @Override
            public Value visit(Copier param, VaArg node) {
                return param.getBlockBuilder().vaArg(param.copyValue(node.getVaList()), node.getType());
            }

            @Override
            public Value visit(Copier copier, VirtualMethodLookup node) {
                copier.copyNode(node.getDependency());
                return copier.getBlockBuilder().lookupVirtualMethod(copier.copyValue(node.getReference()), node.getMethod());
            }

            @Override
            public Value visit(Copier param, ByteOffsetPointer node) {
                return param.getBlockBuilder().byteOffsetPointer(param.copyValue(node.getBasePointer()), param.copyValue(node.getOffset()), node.getOutputType());
            }

            @Override
            public Value visit(Copier param, Xor node) {
                return param.getBlockBuilder().xor(param.copyValue(node.getLeftInput()), param.copyValue(node.getRightInput()));
            }
        }
    }
}

