/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.PointerType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class OffsetPointer
extends AbstractValue {
    private final Value basePointer;
    private final Value offset;

    OffsetPointer(Node callSite, ExecutableElement element, int line, int bci, Value basePointer, Value offset) {
        super(callSite, element, line, bci);
        this.basePointer = basePointer;
        this.offset = offset;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(OffsetPointer.class, this.basePointer, this.offset);
    }

    @Override
    String getNodeName() {
        return "OffsetPointer";
    }

    @Override
    public int getValueDependencyCount() {
        return 2;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> this.basePointer;
            case 1 -> this.offset;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public boolean equals(Object other) {
        OffsetPointer op;
        return other instanceof OffsetPointer && this.equals(op = (OffsetPointer)other);
    }

    public boolean equals(OffsetPointer other) {
        return this == other || other != null && this.basePointer.equals(other.basePointer) && this.offset.equals(other.offset);
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        return this.offset.toReferenceString(this.basePointer.toReferenceString(b.append("offset ")).append(" by "));
    }

    @Override
    public PointerType getType() {
        return this.basePointer.getType(PointerType.class);
    }

    public Value getBasePointer() {
        return this.basePointer;
    }

    public Value getOffset() {
        return this.offset;
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

