/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import org.qbicc.graph.AbstractBinaryValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.NonCommutativeBinaryValue;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.PointerType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class PointerDifference
extends AbstractBinaryValue
implements NonCommutativeBinaryValue {
    private final SignedIntegerType type;

    PointerDifference(Node callSite, ExecutableElement element, int line, int bci, Value left, Value right) {
        super(callSite, element, line, bci, left, right);
        PointerType leftType = left.getType(PointerType.class);
        PointerType rightType = right.getType(PointerType.class);
        if (!leftType.equals(rightType)) {
            throw new IllegalStateException();
        }
        this.type = leftType.getSameSizedSignedInteger();
    }

    @Override
    String getNodeName() {
        return "PointerDifference";
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        b.append("ptrdiff (");
        this.getLeftInput().toReferenceString(b);
        b.append(" - ");
        this.getRightInput().toReferenceString(b);
        b.append(')');
        return b;
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public SignedIntegerType getType() {
        return this.type;
    }
}

