/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class ReadModifyWrite
extends AbstractValue
implements OrderedNode {
    private final Node dependency;
    private final Value pointer;
    private final Value updateValue;
    private final ReadAccessMode readMode;
    private final WriteAccessMode writeMode;
    private final Op op;

    ReadModifyWrite(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value pointer, Op op, Value updateValue, ReadAccessMode readMode, WriteAccessMode writeMode) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.pointer = pointer;
        this.updateValue = updateValue;
        this.readMode = readMode;
        this.writeMode = writeMode;
        this.op = op;
        if (!pointer.isWritable()) {
            throw new IllegalArgumentException("Handle is not writable");
        }
        if (!pointer.isReadable()) {
            throw new IllegalArgumentException("Handle is not readable");
        }
    }

    @Override
    public ValueType getType() {
        return this.updateValue.getType();
    }

    public Op getOp() {
        return this.op;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    public Value getPointer() {
        return this.pointer;
    }

    public Value getUpdateValue() {
        return this.updateValue;
    }

    public ReadAccessMode getReadAccessMode() {
        return this.readMode;
    }

    public WriteAccessMode getWriteAccessMode() {
        return this.writeMode;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.getClass(), this.dependency, this.pointer, this.updateValue, this.readMode, this.writeMode);
    }

    @Override
    String getNodeName() {
        return "ReadModifyWrite";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ReadModifyWrite && this.equals((ReadModifyWrite)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('.');
        b.append((Object)this.op);
        b.append('(');
        this.updateValue.toReferenceString(b);
        b.append(',');
        b.append(this.readMode);
        b.append(',');
        b.append(this.writeMode);
        b.append(')');
        return b;
    }

    private boolean equals(ReadModifyWrite other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.pointer.equals(other.pointer) && this.updateValue.equals(other.updateValue) && this.readMode.equals(other.readMode) && this.writeMode.equals(other.writeMode);
    }

    @Override
    public int getValueDependencyCount() {
        return 2;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> this.pointer;
            case 1 -> this.updateValue;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    public static enum Op {
        SET,
        ADD,
        SUB,
        BITWISE_AND,
        BITWISE_NAND,
        BITWISE_OR,
        BITWISE_XOR,
        MIN,
        MAX;

    }
}

