/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.qbicc.graph.AbstractTerminator;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.Node;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.BlockLiteral;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Ret
extends AbstractTerminator
implements Terminator {
    private final Node dependency;
    private final Value returnAddressValue;
    private final BasicBlock terminatedBlock;
    private List<BasicBlock> successors;

    Ret(Node callSite, ExecutableElement element, int line, int bci, BlockEntry blockEntry, Node dependency, Value returnAddressValue, Map<Slot, Value> targetArguments) {
        super(callSite, element, line, bci, targetArguments);
        this.terminatedBlock = new BasicBlock(blockEntry, this);
        this.dependency = dependency;
        this.returnAddressValue = returnAddressValue;
    }

    @Override
    public BasicBlock getTerminatedBlock() {
        return this.terminatedBlock;
    }

    public Value getReturnAddressValue() {
        return this.returnAddressValue;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.returnAddressValue : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public <T, R> R accept(TerminatorVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.dependency, this.returnAddressValue);
    }

    @Override
    public int getSuccessorCount() {
        return this.getSuccessors().size();
    }

    @Override
    public BasicBlock getSuccessor(int index) {
        return this.getSuccessors().get(index);
    }

    public List<BasicBlock> getSuccessors() {
        List<BasicBlock> successors = this.successors;
        if (successors == null) {
            Value value = this.returnAddressValue;
            if (value instanceof BlockLiteral) {
                BlockLiteral bl = (BlockLiteral)value;
                this.successors = List.of(bl.getBlock());
                return this.successors;
            }
            Value value2 = this.returnAddressValue;
            if (value2 instanceof BlockParameter) {
                BlockParameter bp = (BlockParameter)value2;
                Set<Value> possibleValues = bp.getPossibleValues();
                successors = new ArrayList<BasicBlock>(possibleValues.size());
                for (Value possibleValue : possibleValues) {
                    if (possibleValue instanceof BlockLiteral) {
                        BlockLiteral bl = (BlockLiteral)possibleValue;
                        successors.add(bl.getBlock());
                        continue;
                    }
                    throw Ret.invalidSuccessor();
                }
                this.successors = List.copyOf(successors);
                return this.successors;
            }
            throw Ret.invalidSuccessor();
        }
        return successors;
    }

    private static IllegalArgumentException invalidSuccessor() {
        return new IllegalArgumentException("Invalid successor for `Ret` node");
    }

    @Override
    String getNodeName() {
        return "Ret";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Ret && this.equals((Ret)other);
    }

    public boolean equals(Ret other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.returnAddressValue.equals(other.returnAddressValue);
    }
}

