/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Select
extends AbstractValue {
    private final Value condition;
    private final Value trueValue;
    private final Value falseValue;

    Select(Node callSite, ExecutableElement element, int line, int bci, Value condition, Value trueValue, Value falseValue) {
        super(callSite, element, line, bci);
        this.condition = condition;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    public Value getCondition() {
        return this.condition;
    }

    public Value getTrueValue() {
        return this.trueValue;
    }

    public Value getFalseValue() {
        return this.falseValue;
    }

    @Override
    public ValueType getType() {
        return this.getTrueValue().getType();
    }

    @Override
    public int getValueDependencyCount() {
        return 3;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.getCondition() : (index == 1 ? this.getTrueValue() : (index == 2 ? this.getFalseValue() : (Value)Util.throwIndexOutOfBounds(index)));
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isConstant() {
        return this.condition.isConstant() && this.trueValue.isConstant() && this.falseValue.isConstant();
    }

    @Override
    public boolean isNullable() {
        return this.trueValue.isNullable() || this.falseValue.isNullable();
    }

    @Override
    int calcHashCode() {
        return Objects.hash(Select.class, this.condition, this.trueValue, this.falseValue);
    }

    @Override
    String getNodeName() {
        return "Select";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Select && this.equals((Select)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.condition.toReferenceString(b);
        b.append('?');
        this.trueValue.toReferenceString(b);
        b.append(':');
        this.falseValue.toReferenceString(b);
        b.append(')');
        return b;
    }

    public boolean equals(Select other) {
        return this == other || other != null && this.condition.equals(other.condition) && this.trueValue.equals(other.trueValue) && this.falseValue.equals(other.falseValue);
    }
}

