/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Location;
import org.qbicc.graph.Add;
import org.qbicc.graph.And;
import org.qbicc.graph.Auto;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BitCast;
import org.qbicc.graph.BitReverse;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.ByteOffsetPointer;
import org.qbicc.graph.ByteSwap;
import org.qbicc.graph.Call;
import org.qbicc.graph.CallNoReturn;
import org.qbicc.graph.CallNoSideEffects;
import org.qbicc.graph.CheckCast;
import org.qbicc.graph.ClassOf;
import org.qbicc.graph.Cmp;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.CmpG;
import org.qbicc.graph.CmpL;
import org.qbicc.graph.Comp;
import org.qbicc.graph.Convert;
import org.qbicc.graph.CountLeadingZeros;
import org.qbicc.graph.CountTrailingZeros;
import org.qbicc.graph.CurrentThread;
import org.qbicc.graph.DebugAddressDeclaration;
import org.qbicc.graph.DebugValueDeclaration;
import org.qbicc.graph.DecodeReference;
import org.qbicc.graph.Dereference;
import org.qbicc.graph.Div;
import org.qbicc.graph.ElementOf;
import org.qbicc.graph.Extend;
import org.qbicc.graph.ExtractElement;
import org.qbicc.graph.ExtractInstanceField;
import org.qbicc.graph.ExtractMember;
import org.qbicc.graph.Fence;
import org.qbicc.graph.Goto;
import org.qbicc.graph.If;
import org.qbicc.graph.InitCheck;
import org.qbicc.graph.InitializeClass;
import org.qbicc.graph.InsertElement;
import org.qbicc.graph.InsertMember;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.InstanceOf;
import org.qbicc.graph.InterfaceMethodLookup;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.InvokeNoReturn;
import org.qbicc.graph.IsEq;
import org.qbicc.graph.IsGe;
import org.qbicc.graph.IsGt;
import org.qbicc.graph.IsLe;
import org.qbicc.graph.IsLt;
import org.qbicc.graph.IsNe;
import org.qbicc.graph.Load;
import org.qbicc.graph.Max;
import org.qbicc.graph.MemberOf;
import org.qbicc.graph.MemberOfUnion;
import org.qbicc.graph.Min;
import org.qbicc.graph.Mod;
import org.qbicc.graph.MonitorEnter;
import org.qbicc.graph.MonitorExit;
import org.qbicc.graph.MultiNewArray;
import org.qbicc.graph.Multiply;
import org.qbicc.graph.Neg;
import org.qbicc.graph.New;
import org.qbicc.graph.NewArray;
import org.qbicc.graph.NewReferenceArray;
import org.qbicc.graph.Node;
import org.qbicc.graph.NotNull;
import org.qbicc.graph.OffsetOfField;
import org.qbicc.graph.OffsetPointer;
import org.qbicc.graph.Or;
import org.qbicc.graph.PointerDifference;
import org.qbicc.graph.Reachable;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Ret;
import org.qbicc.graph.Return;
import org.qbicc.graph.Rol;
import org.qbicc.graph.Ror;
import org.qbicc.graph.SafePoint;
import org.qbicc.graph.Select;
import org.qbicc.graph.Shl;
import org.qbicc.graph.Shr;
import org.qbicc.graph.Slot;
import org.qbicc.graph.StackAllocation;
import org.qbicc.graph.Store;
import org.qbicc.graph.Sub;
import org.qbicc.graph.Switch;
import org.qbicc.graph.TailCall;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.Throw;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.Unreachable;
import org.qbicc.graph.VaArg;
import org.qbicc.graph.Value;
import org.qbicc.graph.VirtualMethodLookup;
import org.qbicc.graph.Xor;
import org.qbicc.graph.atomic.GlobalAccessMode;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.InstanceMethodType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.PrimitiveArrayObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeType;
import org.qbicc.type.UnionType;
import org.qbicc.type.ValueType;
import org.qbicc.type.VoidType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.LocalVariableElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.methodhandle.MethodMethodHandleConstant;

final class SimpleBasicBlockBuilder
implements BasicBlockBuilder {
    private BlockLabel firstBlock;
    private int line;
    private int bci;
    private Node dependency;
    private BlockEntry blockEntry;
    private BlockLabel currentBlock;
    private BasicBlockBuilder firstBuilder;
    private ExecutableElement element;
    private final ExecutableElement rootElement;
    private Node callSite;
    private BasicBlock terminatedBlock;
    private Map<BlockLabel, Map<Slot, BlockParameter>> parameters;
    private final Map<Value, Value> unique = new HashMap<Value, Value>();

    SimpleBasicBlockBuilder(ExecutableElement element) {
        this.element = element;
        this.rootElement = element;
        this.bci = -1;
        this.parameters = new HashMap<BlockLabel, Map<Slot, BlockParameter>>();
    }

    @Override
    public BlockParameter addParam(BlockLabel owner, Slot slot, ValueType type, boolean nullable) {
        Map subMap = this.parameters.computeIfAbsent(owner, SimpleBasicBlockBuilder::newMap);
        BlockParameter parameter = (BlockParameter)subMap.get(slot);
        if (parameter != null) {
            if (parameter.getSlot().equals(slot) && parameter.getType().equals(type) && parameter.isNullable() == nullable) {
                return parameter;
            }
            throw new IllegalArgumentException("Parameter " + slot + " already defined to " + owner);
        }
        if (nullable && !(type instanceof NullableType)) {
            throw new IllegalArgumentException("Parameter can only be nullable if its type is nullable");
        }
        parameter = new BlockParameter(this.callSite, this.element, this.line, this.bci, type, nullable, owner, slot);
        subMap.put(slot, parameter);
        return parameter;
    }

    @Override
    public BlockParameter getParam(BlockLabel owner, Slot slot) throws NoSuchElementException {
        BlockParameter parameter = (BlockParameter)this.parameters.getOrDefault(owner, Map.of()).get(slot);
        if (parameter == null) {
            throw new NoSuchElementException("No parameter for slot " + slot + " in " + owner);
        }
        return parameter;
    }

    @Override
    public BasicBlockBuilder getFirstBuilder() {
        return this.firstBuilder;
    }

    @Override
    public void setFirstBuilder(BasicBlockBuilder first) {
        this.firstBuilder = (BasicBlockBuilder)Assert.checkNotNullParam((String)"first", (Object)first);
    }

    @Override
    public ExecutableElement getCurrentElement() {
        return this.element;
    }

    @Override
    public ExecutableElement getRootElement() {
        return this.rootElement;
    }

    @Override
    public ExecutableElement setCurrentElement(ExecutableElement element) {
        ExecutableElement old = this.element;
        this.element = element;
        return old;
    }

    @Override
    public Node getCallSite() {
        return this.callSite;
    }

    @Override
    public Node setCallSite(Node callSite) {
        Node old = this.callSite;
        this.callSite = callSite;
        return old;
    }

    @Override
    public Location getLocation() {
        return Location.builder().setElement(this.element).setLineNumber(this.line).setByteCodeIndex(this.bci).build();
    }

    @Override
    public int setLineNumber(int newLineNumber) {
        try {
            int n = this.line;
            return n;
        }
        finally {
            this.line = newLineNumber;
        }
    }

    @Override
    public int setBytecodeIndex(int newBytecodeIndex) {
        try {
            int n = this.bci;
            return n;
        }
        finally {
            this.bci = newBytecodeIndex;
        }
    }

    @Override
    public int getBytecodeIndex() {
        return this.bci;
    }

    @Override
    public void finish() {
        if (this.currentBlock != null) {
            throw new IllegalStateException("Current block not terminated");
        }
        if (this.firstBlock != null) {
            this.mark(BlockLabel.getTargetOf(this.firstBlock), null);
            this.computeLoops(BlockLabel.getTargetOf(this.firstBlock), new ArrayList<BasicBlock>(), new HashSet<BasicBlock>(), new HashSet<BasicBlock>(), new HashMap<Set<BasicBlock.Loop>, Map<BasicBlock.Loop, Set<BasicBlock.Loop>>>());
            this.getContext().getScheduler().schedule(this.getFirstBlock());
        }
    }

    @Override
    public BasicBlock getFirstBlock() throws IllegalStateException {
        BlockLabel firstBlock = this.firstBlock;
        if (firstBlock != null && firstBlock.hasTarget()) {
            return BlockLabel.getTargetOf(firstBlock);
        }
        throw new IllegalStateException("First block not yet terminated");
    }

    @Override
    public BlockLabel getEntryLabel() throws IllegalStateException {
        BlockLabel firstBlock = this.firstBlock;
        if (firstBlock != null) {
            return firstBlock;
        }
        throw new IllegalStateException("First block not yet started");
    }

    private void mark(BasicBlock block, BasicBlock from) {
        if (block.setReachableFrom(from)) {
            Terminator terminator = block.getTerminator();
            int cnt = terminator.getSuccessorCount();
            for (int i = 0; i < cnt; ++i) {
                this.mark(terminator.getSuccessor(i), block);
            }
        }
    }

    private void computeLoops(BasicBlock block, ArrayList<BasicBlock> blocks, HashSet<BasicBlock> blocksSet, HashSet<BasicBlock> visited, Map<Set<BasicBlock.Loop>, Map<BasicBlock.Loop, Set<BasicBlock.Loop>>> cache) {
        if (!visited.add(block)) {
            return;
        }
        blocks.add(block);
        blocksSet.add(block);
        Terminator terminator = block.getTerminator();
        int cnt = terminator.getSuccessorCount();
        for (int i = 0; i < cnt; ++i) {
            BasicBlock successor = terminator.getSuccessor(i);
            if (blocksSet.contains(successor)) {
                int idx = blocks.indexOf(successor);
                assert (idx != -1);
                BasicBlock.Loop loop = new BasicBlock.Loop(successor, block);
                for (int j = idx; j < blocks.size(); ++j) {
                    BasicBlock member = blocks.get(j);
                    Set<BasicBlock.Loop> oldLoops = member.getLoops();
                    member.setLoops(cache.computeIfAbsent(oldLoops, SimpleBasicBlockBuilder::newMap).computeIfAbsent(loop, l -> SimpleBasicBlockBuilder.setWith(oldLoops, l)));
                }
                continue;
            }
            this.computeLoops(successor, blocks, blocksSet, visited, cache);
        }
        BasicBlock removed = blocks.remove(blocks.size() - 1);
        assert (removed == block);
        blocksSet.remove(block);
    }

    private static <K, V> Map<K, V> newMap(Object arg) {
        return new HashMap();
    }

    private static <E> Set<E> setWith(Set<E> set, E item) {
        if (set.contains(item)) {
            return set;
        }
        int size = set.size();
        if (size == 0) {
            return Set.of(item);
        }
        if (size == 1) {
            return Set.of(set.iterator().next(), item);
        }
        if (size == 2) {
            Iterator<E> iterator = set.iterator();
            return Set.of(iterator.next(), iterator.next(), item);
        }
        Object[] array = set.toArray(new Object[size + 1]);
        array[size] = item;
        return Set.of(array);
    }

    @Override
    public Value add(Value v1, Value v2) {
        return this.unique(new Add(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value multiply(Value v1, Value v2) {
        return this.unique(new Multiply(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value and(Value v1, Value v2) {
        return this.unique(new And(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value or(Value v1, Value v2) {
        return this.unique(new Or(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value xor(Value v1, Value v2) {
        return this.unique(new Xor(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value isEq(Value v1, Value v2) {
        return this.unique(new IsEq(this.callSite, this.element, this.line, this.bci, v1, v2, this.getTypeSystem().getBooleanType()));
    }

    @Override
    public Value isNe(Value v1, Value v2) {
        return this.unique(new IsNe(this.callSite, this.element, this.line, this.bci, v1, v2, this.getTypeSystem().getBooleanType()));
    }

    @Override
    public Value shr(Value v1, Value v2) {
        return this.unique(new Shr(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value shl(Value v1, Value v2) {
        return this.unique(new Shl(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value sub(Value v1, Value v2) {
        return this.unique(new Sub(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value divide(Value v1, Value v2) {
        return this.unique(new Div(this.callSite, this.element, this.line, this.bci, v1, v2, this.requireDependency()));
    }

    @Override
    public Value remainder(Value v1, Value v2) {
        return this.unique(new Mod(this.callSite, this.element, this.line, this.bci, v1, v2, this.requireDependency()));
    }

    @Override
    public Value min(Value v1, Value v2) {
        return this.unique(new Min(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value max(Value v1, Value v2) {
        return this.unique(new Max(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value isLt(Value v1, Value v2) {
        return this.unique(new IsLt(this.callSite, this.element, this.line, this.bci, v1, v2, this.getTypeSystem().getBooleanType()));
    }

    @Override
    public Value isGt(Value v1, Value v2) {
        return this.unique(new IsGt(this.callSite, this.element, this.line, this.bci, v1, v2, this.getTypeSystem().getBooleanType()));
    }

    @Override
    public Value isLe(Value v1, Value v2) {
        return this.unique(new IsLe(this.callSite, this.element, this.line, this.bci, v1, v2, this.getTypeSystem().getBooleanType()));
    }

    @Override
    public Value isGe(Value v1, Value v2) {
        return this.unique(new IsGe(this.callSite, this.element, this.line, this.bci, v1, v2, this.getTypeSystem().getBooleanType()));
    }

    @Override
    public Value rol(Value v1, Value v2) {
        return this.unique(new Rol(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value ror(Value v1, Value v2) {
        return this.unique(new Ror(this.callSite, this.element, this.line, this.bci, v1, v2));
    }

    @Override
    public Value cmp(Value v1, Value v2) {
        return this.unique(new Cmp(this.callSite, this.element, this.line, this.bci, v1, v2, this.getTypeSystem().getSignedInteger32Type()));
    }

    @Override
    public Value cmpG(Value v1, Value v2) {
        return this.unique(new CmpG(this.callSite, this.element, this.line, this.bci, v1, v2, this.getTypeSystem().getSignedInteger32Type()));
    }

    @Override
    public Value cmpL(Value v1, Value v2) {
        return this.unique(new CmpL(this.callSite, this.element, this.line, this.bci, v1, v2, this.getTypeSystem().getSignedInteger32Type()));
    }

    @Override
    public Value notNull(Value v) {
        return v.isNullable() ? this.unique(new NotNull(this.callSite, this.element, this.line, this.bci, v)) : v;
    }

    @Override
    public Value negate(Value v) {
        return this.unique(new Neg(this.callSite, this.element, this.line, this.bci, v));
    }

    @Override
    public Value complement(Value v) {
        Assert.checkNotNullParam((String)"v", (Object)v);
        if (!(v.getType() instanceof IntegerType) && !(v.getType() instanceof BooleanType)) {
            throw new IllegalArgumentException("Invalid input type");
        }
        return this.unique(new Comp(this.callSite, this.element, this.line, this.bci, v));
    }

    @Override
    public Value byteSwap(Value v) {
        return this.unique(new ByteSwap(this.callSite, this.element, this.line, this.bci, v));
    }

    @Override
    public Value bitReverse(Value v) {
        return this.unique(new BitReverse(this.callSite, this.element, this.line, this.bci, v));
    }

    @Override
    public Value countLeadingZeros(Value v) {
        return this.unique(new CountLeadingZeros(this.callSite, this.element, this.line, this.bci, v, this.getTypeSystem().getSignedInteger32Type()));
    }

    @Override
    public Value countTrailingZeros(Value v) {
        return this.unique(new CountTrailingZeros(this.callSite, this.element, this.line, this.bci, v, this.getTypeSystem().getSignedInteger32Type()));
    }

    @Override
    public Value populationCount(Value v) {
        throw Assert.unsupported();
    }

    @Override
    public Value loadLength(Value arrayPointer) {
        throw new IllegalStateException("loadLength not converted");
    }

    @Override
    public Value loadTypeId(Value objectPointer) {
        throw new IllegalStateException("loadTypeId not converted");
    }

    @Override
    public Value truncate(Value value, WordType toType) {
        return this.unique(new Truncate(this.callSite, this.element, this.line, this.bci, value, toType));
    }

    @Override
    public Value extend(Value value, WordType toType) {
        return this.unique(new Extend(this.callSite, this.element, this.line, this.bci, value, toType));
    }

    @Override
    public Value bitCast(Value value, WordType toType) {
        return this.unique(new BitCast(this.callSite, this.element, this.line, this.bci, value, toType));
    }

    @Override
    public Value valueConvert(Value value, WordType toType) {
        return this.unique(new Convert(this.callSite, this.element, this.line, this.bci, value, toType));
    }

    @Override
    public Value decodeReference(Value refVal, PointerType pointerType) {
        return this.unique(new DecodeReference(this.callSite, this.element, this.line, this.bci, this.requireDependency(), refVal, pointerType));
    }

    @Override
    public Value instanceOf(Value input, ObjectType expectedType, int expectedDimensions) {
        BasicBlockBuilder fb = this.getFirstBuilder();
        ObjectType ifTrueExpectedType = expectedType;
        for (int i = 0; i < expectedDimensions; ++i) {
            ifTrueExpectedType = ifTrueExpectedType.getReferenceArrayObject();
        }
        return this.asDependency(new InstanceOf(this.callSite, this.element, this.line, this.bci, this.requireDependency(), input, fb.notNull(fb.bitCast(input, ((ReferenceType)input.getType()).narrow(ifTrueExpectedType))), expectedType, expectedDimensions, this.getTypeSystem().getBooleanType()));
    }

    @Override
    public Value instanceOf(Value input, TypeDescriptor desc) {
        throw new IllegalStateException("InstanceOf of unresolved type");
    }

    @Override
    public Value checkcast(Value value, Value toType, Value toDimensions, CheckCast.CastType kind, ObjectType expectedType) {
        ValueType inputType = value.getType();
        if (inputType instanceof VoidType) {
            return value;
        }
        if (!(inputType instanceof ReferenceType)) {
            throw new IllegalArgumentException("Only references can be checkcast");
        }
        ValueType toTypeTypeRaw = toType.getType();
        if (!(toTypeTypeRaw instanceof TypeType)) {
            throw new IllegalArgumentException("Invalid type for toType argument");
        }
        ReferenceType outputType = ((ReferenceType)inputType).narrow(expectedType);
        if (outputType == null) {
            throw new IllegalStateException(String.format("Invalid cast from %s to %s", inputType, expectedType));
        }
        return this.asDependency(new CheckCast(this.callSite, this.element, this.line, this.bci, this.requireDependency(), value, toType, toDimensions, kind, expectedType));
    }

    @Override
    public Value checkcast(Value value, TypeDescriptor desc) {
        throw new IllegalStateException("CheckCast of unresolved type");
    }

    @Override
    public Value deref(Value pointer) {
        return this.unique(new Dereference(this.callSite, this.element, this.line, this.bci, pointer));
    }

    @Override
    public Value invokeDynamic(MethodMethodHandleConstant bootstrapHandle, List<Literal> bootstrapArgs, String name, MethodDescriptor descriptor, List<Value> arguments) {
        this.getContext().error(this.getLocation(), "Unhandled `invokeDynamic`", new Object[0]);
        throw new BlockEarlyTermination(this.unreachable());
    }

    @Override
    public Value currentThread() {
        ReferenceType refType = this.element.getEnclosingType().getContext().getCompilationContext().getBootstrapClassContext().findDefinedType("java/lang/Thread").load().getObjectType().getReference();
        return this.unique(new CurrentThread(this.callSite, this.element, this.line, this.bci, refType));
    }

    @Override
    public Value vaArg(Value vaList, ValueType type) {
        return this.asDependency(new VaArg(this.callSite, this.element, this.line, this.bci, this.requireDependency(), vaList, type));
    }

    @Override
    public Value memberOf(Value structPointer, CompoundType.Member member) {
        return this.unique(new MemberOf(this.callSite, this.element, this.line, this.bci, structPointer, member));
    }

    @Override
    public Value memberOfUnion(Value unionPointer, UnionType.Member member) {
        return this.unique(new MemberOfUnion(this.callSite, this.element, this.line, this.bci, unionPointer, member));
    }

    @Override
    public Value elementOf(Value arrayPointer, Value index) {
        return this.unique(new ElementOf(this.callSite, this.element, this.line, this.bci, arrayPointer, index));
    }

    @Override
    public Value offsetPointer(Value basePointer, Value offset) {
        return this.unique(new OffsetPointer(this.callSite, this.element, this.line, this.bci, basePointer, offset));
    }

    @Override
    public Value pointerDifference(Value leftPointer, Value rightPointer) {
        return this.unique(new PointerDifference(this.callSite, this.element, this.line, this.bci, leftPointer, rightPointer));
    }

    @Override
    public Value byteOffsetPointer(Value base, Value offset, ValueType outputType) {
        return this.unique(new ByteOffsetPointer(this.callSite, this.element, this.line, this.bci, base, offset, outputType));
    }

    @Override
    public Value lookupVirtualMethod(Value reference, TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        throw new IllegalStateException("lookupVirtualMethod of unresolved type");
    }

    @Override
    public Value lookupVirtualMethod(Value reference, InstanceMethodElement method) {
        return this.unique(new VirtualMethodLookup(this.callSite, this.element, this.line, this.bci, this.requireDependency(), reference, method));
    }

    @Override
    public Value lookupInterfaceMethod(Value reference, TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        throw new IllegalStateException("lookupInterfaceMethod of unresolved type");
    }

    @Override
    public Value lookupInterfaceMethod(Value reference, InstanceMethodElement method) {
        return this.unique(new InterfaceMethodLookup(this.callSite, this.element, this.line, this.bci, this.requireDependency(), reference, method));
    }

    @Override
    public Value resolveStaticMethod(TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        throw new IllegalStateException("resolveStaticMethod of unresolved type");
    }

    @Override
    public Value resolveInstanceMethod(TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        throw new IllegalStateException("resolveInstanceMethod of unresolved type");
    }

    @Override
    public Value resolveConstructor(TypeDescriptor owner, MethodDescriptor descriptor) {
        throw new IllegalStateException("resolveConstructor of unresolved type");
    }

    @Override
    public Value resolveStaticField(TypeDescriptor owner, String name, TypeDescriptor type) {
        throw new IllegalStateException("Static field of unresolved type");
    }

    @Override
    public Value instanceFieldOf(Value instancePointer, InstanceFieldElement field) {
        return this.unique(new InstanceFieldOf(this.callSite, this.element, this.line, this.bci, instancePointer, field));
    }

    @Override
    public Value instanceFieldOf(Value instancePointer, TypeDescriptor owner, String name, TypeDescriptor type) {
        throw new IllegalStateException("Instance field of unresolved type");
    }

    @Override
    public Value auto(Value initializer) {
        return this.unique(new Auto(this.callSite, this.element, this.line, this.bci, this.requireDependency(), initializer));
    }

    @Override
    public Value stackAllocate(ValueType type, Value count, Value align) {
        return this.asDependency(new StackAllocation(this.callSite, this.element, this.line, this.bci, this.requireDependency(), type, count, align));
    }

    @Override
    public Value offsetOfField(FieldElement fieldElement) {
        return this.unique(new OffsetOfField(this.callSite, this.element, this.line, this.bci, fieldElement, this.getTypeSystem().getSignedInteger32Type()));
    }

    @Override
    public Value extractElement(Value array, Value index) {
        return this.unique(new ExtractElement(this.callSite, this.element, this.line, this.bci, array, index));
    }

    @Override
    public Value extractMember(Value compound, CompoundType.Member member) {
        return this.unique(new ExtractMember(this.callSite, this.element, this.line, this.bci, compound, member));
    }

    @Override
    public Value extractInstanceField(Value valueObj, TypeDescriptor owner, String name, TypeDescriptor type) {
        throw new IllegalStateException("Field access of unresolved class");
    }

    @Override
    public Value extractInstanceField(Value valueObj, FieldElement field) {
        return new ExtractInstanceField(this.callSite, this.element, this.line, this.bci, valueObj, field, field.getType());
    }

    @Override
    public Value insertElement(Value array, Value index, Value value) {
        return this.unique(new InsertElement(this.callSite, this.element, this.line, this.bci, array, index, value));
    }

    @Override
    public Value insertMember(Value compound, CompoundType.Member member, Value value) {
        return this.unique(new InsertMember(this.callSite, this.element, this.line, this.bci, compound, value, member));
    }

    @Override
    public Node declareDebugAddress(LocalVariableElement variable, Value address) {
        return this.asDependency(new DebugAddressDeclaration(this.callSite, this.element, this.line, this.bci, this.requireDependency(), variable, address));
    }

    @Override
    public Node setDebugValue(LocalVariableElement variable, Value value) {
        return this.asDependency(new DebugValueDeclaration(this.callSite, this.element, this.line, this.bci, this.requireDependency(), variable, value));
    }

    @Override
    public Value select(Value condition, Value trueValue, Value falseValue) {
        return this.unique(new Select(this.callSite, this.element, this.line, this.bci, condition, trueValue, falseValue));
    }

    @Override
    public Value classOf(Value typeId, Value dimensions) {
        Assert.assertTrue((boolean)(typeId instanceof TypeLiteral));
        ClassContext classContext = this.element.getEnclosingType().getContext();
        ClassObjectType type = classContext.findDefinedType("java/lang/Class").load().getClassType();
        return this.unique(new ClassOf(this.callSite, this.element, this.line, this.bci, typeId, dimensions, type.getReference()));
    }

    @Override
    public Value new_(ClassObjectType type, Value typeId, Value size, Value align) {
        return this.asDependency(new New(this.callSite, this.element, this.line, this.bci, this.requireDependency(), type, typeId, size, align));
    }

    @Override
    public Value new_(ClassTypeDescriptor desc) {
        throw new IllegalStateException("New of unresolved class");
    }

    @Override
    public Value newArray(PrimitiveArrayObjectType arrayType, Value size) {
        return this.asDependency(new NewArray(this.callSite, this.element, this.line, this.bci, this.requireDependency(), arrayType, size));
    }

    @Override
    public Value newArray(ArrayTypeDescriptor desc, Value size) {
        throw new IllegalStateException("New of unresolved array type");
    }

    @Override
    public Value newReferenceArray(ReferenceArrayObjectType arrayType, Value elemTypeId, Value dimensions, Value size) {
        return this.asDependency(new NewReferenceArray(this.callSite, this.element, this.line, this.bci, this.requireDependency(), arrayType, elemTypeId, dimensions, size));
    }

    @Override
    public Value multiNewArray(ArrayObjectType arrayType, List<Value> dimensions) {
        return this.asDependency(new MultiNewArray(this.callSite, this.element, this.line, this.bci, this.requireDependency(), arrayType, dimensions));
    }

    @Override
    public Value multiNewArray(ArrayTypeDescriptor desc, List<Value> dimensions) {
        throw new IllegalStateException("New of unresolved array type");
    }

    @Override
    public Value load(Value pointer, ReadAccessMode mode) {
        return this.asDependency(new Load(this.callSite, this.element, this.line, this.bci, this.requireDependency(), pointer, mode));
    }

    @Override
    public Value readModifyWrite(Value pointer, ReadModifyWrite.Op op, Value update, ReadAccessMode readMode, WriteAccessMode writeMode) {
        return this.asDependency(new ReadModifyWrite(this.callSite, this.element, this.line, this.bci, this.requireDependency(), pointer, op, update, readMode, writeMode));
    }

    @Override
    public Value cmpAndSwap(Value pointer, Value expect, Value update, ReadAccessMode readMode, WriteAccessMode writeMode, CmpAndSwap.Strength strength) {
        CompilationContext ctxt = this.getCurrentElement().getEnclosingType().getContext().getCompilationContext();
        return this.asDependency(new CmpAndSwap(this.callSite, this.element, this.line, this.bci, CmpAndSwap.getResultType(ctxt, pointer.getPointeeType()), this.requireDependency(), pointer, expect, update, readMode, writeMode, strength));
    }

    @Override
    public Node store(Value handle, Value value, WriteAccessMode mode) {
        return this.asDependency(new Store(this.callSite, this.element, this.line, this.bci, this.requireDependency(), handle, value, mode));
    }

    @Override
    public Node initCheck(InitializerElement initializer, Value initThunk) {
        return this.asDependency(new InitCheck(this.callSite, this.element, this.line, this.bci, this.requireDependency(), initializer, initThunk));
    }

    @Override
    public Node initializeClass(Value value) {
        return this.asDependency(new InitializeClass(this.callSite, this.element, this.line, this.bci, this.requireDependency(), value));
    }

    @Override
    public Node fence(GlobalAccessMode fenceType) {
        return this.asDependency(new Fence(this.callSite, this.element, this.line, this.bci, this.requireDependency(), fenceType));
    }

    @Override
    public Node monitorEnter(Value obj) {
        return this.asDependency(new MonitorEnter(this.callSite, this.element, this.line, this.bci, this.requireDependency(), (Value)Assert.checkNotNullParam((String)"obj", (Object)obj)));
    }

    @Override
    public Node monitorExit(Value obj) {
        return this.asDependency(new MonitorExit(this.callSite, this.element, this.line, this.bci, this.requireDependency(), (Value)Assert.checkNotNullParam((String)"obj", (Object)obj)));
    }

    @Override
    public Value nullCheck(Value input) {
        throw new IllegalStateException("nullCheck() not intercepted");
    }

    @Override
    public Value divisorCheck(Value input) {
        throw new IllegalStateException("divisorCheck() not intercepted");
    }

    @Override
    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        if (receiver.getType() instanceof VoidType && targetPtr.getPointeeType() instanceof InstanceMethodType) {
            this.getContext().error(this.getLocation(), "Call to instance method without receiver", new Object[0]);
        }
        return this.asDependency(new Call(this.callSite, this.element, this.line, this.bci, this.requireDependency(), targetPtr, receiver, arguments));
    }

    @Override
    public Value callNoSideEffects(Value targetPtr, Value receiver, List<Value> arguments) {
        if (receiver.getType() instanceof VoidType && targetPtr.getPointeeType() instanceof InstanceMethodType) {
            this.getContext().error(this.getLocation(), "Call to instance method without receiver", new Object[0]);
        }
        return this.unique(new CallNoSideEffects(this.callSite, this.element, this.line, this.bci, targetPtr, receiver, arguments));
    }

    @Override
    public Node nop() {
        return this.requireDependency();
    }

    private <N extends Node> N asDependency(N node) {
        this.dependency = node;
        return node;
    }

    private <V extends Value> V unique(V value) {
        Value existing = this.unique.putIfAbsent(value, value);
        return (V)(existing != null ? existing : value);
    }

    @Override
    public Node begin(BlockLabel blockLabel) {
        Assert.checkNotNullParam((String)"blockLabel", (Object)blockLabel);
        if (blockLabel.hasTarget()) {
            throw new IllegalStateException("Block already terminated");
        }
        if (this.currentBlock != null) {
            throw new IllegalStateException("Block already in progress");
        }
        this.currentBlock = blockLabel;
        if (this.firstBlock == null) {
            this.firstBlock = blockLabel;
        }
        this.blockEntry = new BlockEntry(this.callSite, this.element, blockLabel);
        this.dependency = this.blockEntry;
        return this.blockEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> BasicBlock begin(BlockLabel blockLabel, T arg, BiConsumer<T, BasicBlockBuilder> maker) {
        Assert.checkNotNullParam((String)"blockLabel", (Object)blockLabel);
        Assert.checkNotNullParam((String)"maker", maker);
        if (blockLabel.hasTarget()) {
            throw new IllegalStateException("Block already terminated");
        }
        int oldLine = this.line;
        int oldBci = this.bci;
        Node oldDependency = this.dependency;
        BlockEntry oldBlockEntry = this.blockEntry;
        BlockLabel oldCurrentBlock = this.currentBlock;
        BasicBlock oldTerminatedBlock = this.terminatedBlock;
        ExecutableElement oldElement = this.element;
        Node oldCallSite = this.callSite;
        HashMap<BlockLabel, Map<Slot, BlockParameter>> oldParameters = new HashMap<BlockLabel, Map<Slot, BlockParameter>>(this.parameters);
        try {
            BasicBlock basicBlock = this.doBegin(blockLabel, arg, maker);
            return basicBlock;
        }
        finally {
            this.parameters = oldParameters;
            this.callSite = oldCallSite;
            this.element = oldElement;
            this.terminatedBlock = oldTerminatedBlock;
            this.currentBlock = oldCurrentBlock;
            this.blockEntry = oldBlockEntry;
            this.dependency = oldDependency;
            this.bci = oldBci;
            this.line = oldLine;
        }
    }

    private <T> BasicBlock doBegin(BlockLabel blockLabel, T arg, BiConsumer<T, BasicBlockBuilder> maker) {
        try {
            this.currentBlock = blockLabel;
            if (this.firstBlock == null) {
                this.firstBlock = blockLabel;
            }
            this.blockEntry = new BlockEntry(this.callSite, this.element, blockLabel);
            this.dependency = this.blockEntry;
            this.parameters = new HashMap<BlockLabel, Map<Slot, BlockParameter>>();
            maker.accept(arg, this.firstBuilder);
            if (this.currentBlock != null) {
                this.getContext().error(this.getLocation(), "Block not terminated", new Object[0]);
                this.firstBuilder.unreachable();
            }
        }
        catch (BlockEarlyTermination blockEarlyTermination) {
            // empty catch block
        }
        return BlockLabel.getTargetOf(blockLabel);
    }

    @Override
    public Node reachable(Value value) {
        return this.asDependency(new Reachable(this.callSite, this.element, this.line, this.bci, this.requireDependency(), value));
    }

    @Override
    public Node safePoint() {
        return this.asDependency(new SafePoint(this.callSite, this.element, this.line, this.bci, this.requireDependency()));
    }

    @Override
    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        if (receiver.getType() instanceof VoidType && targetPtr.getPointeeType() instanceof InstanceMethodType) {
            this.getContext().error(this.getLocation(), "Call to instance method without receiver", new Object[0]);
        }
        return this.terminate(this.requireCurrentBlock(), new CallNoReturn(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency, targetPtr, receiver, arguments));
    }

    @Override
    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        if (receiver.getType() instanceof VoidType && targetPtr.getPointeeType() instanceof InstanceMethodType) {
            this.getContext().error(this.getLocation(), "Call to instance method without receiver", new Object[0]);
        }
        return this.terminate(this.requireCurrentBlock(), new InvokeNoReturn(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency, targetPtr, receiver, arguments, catchLabel, targetArguments));
    }

    @Override
    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        if (receiver.getType() instanceof VoidType && targetPtr.getPointeeType() instanceof InstanceMethodType) {
            this.getContext().error(this.getLocation(), "Call to instance method without receiver", new Object[0]);
        }
        return this.terminate(this.requireCurrentBlock(), new TailCall(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency, targetPtr, receiver, arguments));
    }

    @Override
    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        if (receiver.getType() instanceof VoidType && targetPtr.getPointeeType() instanceof InstanceMethodType) {
            this.getContext().error(this.getLocation(), "Call to instance method without receiver", new Object[0]);
        }
        BlockLabel currentBlock = this.requireCurrentBlock();
        Invoke invoke = new Invoke(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency, targetPtr, receiver, arguments, catchLabel, resumeLabel, targetArguments);
        this.terminate(currentBlock, invoke);
        return invoke.getReturnValue();
    }

    @Override
    public BasicBlock goto_(BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        return this.terminate(this.requireCurrentBlock(), new Goto(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency, resumeLabel, targetArguments));
    }

    @Override
    public BasicBlock if_(Value condition, BlockLabel trueTarget, BlockLabel falseTarget, Map<Slot, Value> targetArguments) {
        return this.terminate(this.requireCurrentBlock(), new If(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency, condition, trueTarget, falseTarget, targetArguments));
    }

    @Override
    public BasicBlock return_(Value value) {
        if (value == null) {
            return this.return_(this.emptyVoid());
        }
        return this.terminate(this.requireCurrentBlock(), new Return(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency, value));
    }

    @Override
    public BasicBlock unreachable() {
        return this.terminate(this.requireCurrentBlock(), new Unreachable(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency));
    }

    @Override
    public BasicBlock throw_(Value value) {
        return this.terminate(this.requireCurrentBlock(), new Throw(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency, value));
    }

    @Override
    public BasicBlock ret(Value address, Map<Slot, Value> targetArguments) {
        return this.terminate(this.requireCurrentBlock(), new Ret(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency, address, targetArguments));
    }

    @Override
    public BlockEntry getBlockEntry() {
        this.requireCurrentBlock();
        return this.blockEntry;
    }

    @Override
    public BasicBlock getTerminatedBlock() {
        BasicBlock block = this.terminatedBlock;
        if (block == null) {
            throw new IllegalStateException("No block terminated yet");
        }
        return block;
    }

    @Override
    public BasicBlock switch_(Value value, int[] checkValues, BlockLabel[] targets, BlockLabel defaultTarget, Map<Slot, Value> targetArguments) {
        return this.terminate(this.requireCurrentBlock(), new Switch(this.callSite, this.element, this.line, this.bci, this.blockEntry, this.dependency, defaultTarget, checkValues, targets, value, targetArguments));
    }

    private BasicBlock terminate(BlockLabel block, Terminator op) {
        BasicBlock realBlock;
        this.terminatedBlock = realBlock = op.getTerminatedBlock();
        block.setTarget(realBlock);
        this.blockEntry = null;
        this.currentBlock = null;
        this.dependency = null;
        return realBlock;
    }

    private BlockLabel requireCurrentBlock() {
        BlockLabel block = this.currentBlock;
        if (block == null) {
            assert (this.dependency == null);
            throw this.noBlock();
        }
        assert (this.dependency != null);
        return block;
    }

    private Node requireDependency() {
        Node dependency = this.dependency;
        if (dependency == null) {
            assert (this.currentBlock == null);
            throw this.noBlock();
        }
        assert (this.currentBlock != null);
        return dependency;
    }

    private IllegalStateException noBlock() {
        return new IllegalStateException("No block in progress");
    }
}

