/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractNode;
import org.qbicc.graph.Action;
import org.qbicc.graph.ActionVisitor;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.type.definition.element.ExecutableElement;

public class Store
extends AbstractNode
implements Action,
OrderedNode {
    private final Node dependency;
    private final Value pointer;
    private final Value value;
    private final WriteAccessMode mode;

    Store(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value pointer, Value value, WriteAccessMode mode) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.pointer = pointer;
        this.value = value;
        this.mode = mode;
        if (!pointer.isWritable()) {
            throw new IllegalArgumentException("Handle is not writable");
        }
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    public Value getPointer() {
        return this.pointer;
    }

    public Value getValue() {
        return this.value;
    }

    public WriteAccessMode getAccessMode() {
        return this.mode;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.dependency, this.pointer, this.value, this.mode);
    }

    @Override
    String getNodeName() {
        return "Store";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Store && this.equals((Store)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.value.toReferenceString(b);
        b.append(',');
        b.append(this.mode);
        b.append(')');
        return b;
    }

    public boolean equals(Store other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.pointer.equals(other.pointer) && this.value.equals(other.value) && this.mode == other.mode;
    }

    @Override
    public int getValueDependencyCount() {
        return 2;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> this.pointer;
            case 1 -> this.value;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public <T, R> R accept(ActionVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

