/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class VaArg
extends AbstractValue
implements OrderedNode {
    private final Node dependency;
    private final ValueType type;
    private final Value vaList;

    VaArg(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value vaList, ValueType type) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.type = type;
        this.vaList = vaList;
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.dependency, this.type, this.vaList);
    }

    @Override
    String getNodeName() {
        return "VaArg";
    }

    @Override
    public boolean equals(Object other) {
        VaArg va;
        return other instanceof VaArg && this.equals(va = (VaArg)other);
    }

    public boolean equals(VaArg other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.type.equals(other.type) && this.vaList.equals(other.vaList);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public ValueType getType() {
        return this.type;
    }

    public Value getVaList() {
        return this.vaList;
    }

    @Override
    public int getValueDependencyCount() {
        return 1;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return index == 0 ? this.vaList : (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.vaList.toReferenceString(b);
        b.append(',');
        this.type.toString(b);
        b.append(')');
        return b;
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

