/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FloatType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.NullableType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ValueType;

public interface Value
extends Node {
    public static final Value[] NO_VALUES = new Value[0];

    public ValueType getType();

    default public <T extends ValueType> T getType(Class<T> expected) {
        return (T)((ValueType)expected.cast(this.getType()));
    }

    public <T, R> R accept(ValueVisitor<T, R> var1, T var2);

    default public Value unconstrained() {
        return this;
    }

    default public boolean isDefEq(Value other) {
        return this.equals(other) && this.isDefNotNaN() && other.isDefNotNaN();
    }

    default public boolean isDefNe(Value other) {
        return false;
    }

    default public boolean isDefLt(Value other) {
        return false;
    }

    default public boolean isDefGt(Value other) {
        return false;
    }

    default public boolean isDefLe(Value other) {
        return this.equals(other) && this.isDefNotNaN() && other.isDefNotNaN();
    }

    default public boolean isDefGe(Value other) {
        return this.equals(other) && this.isDefNotNaN() && other.isDefNotNaN();
    }

    default public boolean isDefNaN() {
        return false;
    }

    default public Value getValueIfTrue(BasicBlockBuilder bbb, Value input) {
        if (this.equals(input)) {
            return this;
        }
        return input;
    }

    default public Value getValueIfFalse(BasicBlockBuilder bbb, Value input) {
        if (this.equals(input)) {
            return this;
        }
        return input;
    }

    default public Value extractElement(LiteralFactory lf, Value index) {
        return null;
    }

    default public Value extractMember(LiteralFactory lf, CompoundType.Member member) {
        return null;
    }

    default public boolean isDefNotNaN() {
        return !(this.getType() instanceof FloatType);
    }

    default public boolean isNullable() {
        return this.getType() instanceof NullableType;
    }

    default public boolean isConstant() {
        return false;
    }

    default public ValueType getPointeeType() {
        return this.getType(PointerType.class).getPointeeType();
    }

    default public <T extends ValueType> T getPointeeType(Class<T> expected) {
        return this.getType(PointerType.class).getPointeeType(expected);
    }

    default public ValueType getReturnType() {
        return this.getPointeeType(InvokableType.class).getReturnType();
    }

    default public boolean isWritable() {
        return this.getType() instanceof PointerType;
    }

    default public boolean isReadable() {
        return this.getType() instanceof PointerType;
    }

    default public boolean isNoThrow() {
        return false;
    }

    default public boolean isNoSafePoints() {
        return false;
    }

    default public boolean isNoReturn() {
        return false;
    }

    default public boolean isNoSideEffect() {
        return false;
    }

    default public boolean isPointeeConstant() {
        return false;
    }

    default public boolean isFold() {
        return false;
    }

    default public AccessMode getDetectedMode() {
        return AccessModes.SingleUnshared;
    }

    public StringBuilder toReferenceString(StringBuilder var1);
}

