/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.atomic;

import org.qbicc.graph.atomic.AtomicTraits;
import org.qbicc.graph.atomic.GlobalAccessMode;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AccessMode {
    default public boolean includes(AccessMode other) {
        int theirBits;
        int myBits = ((AtomicTraits)((Object)this)).getBits();
        return (myBits | (theirBits = ((AtomicTraits)((Object)other)).getBits())) == myBits;
    }

    default public boolean overlapsWith(AccessMode other) {
        int theirBits;
        int myBits = ((AtomicTraits)((Object)this)).getBits();
        return (myBits & (theirBits = ((AtomicTraits)((Object)other)).getBits())) != 0;
    }

    default public boolean isAtomic() {
        return (((AtomicTraits)((Object)this)).getBits() & 1) != 0;
    }

    default public AccessMode combinedWith(AccessMode other) {
        int myBits = ((AtomicTraits)((Object)this)).getBits();
        int theirBits = ((AtomicTraits)((Object)other)).getBits();
        return AtomicTraits.fromBits(myBits | theirBits);
    }

    default public GlobalAccessMode combinedWith(GlobalAccessMode other) {
        return (GlobalAccessMode)this.combinedWith((AccessMode)other);
    }

    public ReadAccessMode getReadAccess();

    public WriteAccessMode getWriteAccess();

    public GlobalAccessMode getGlobalAccess();
}

