/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.atomic;

import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.graph.atomic.AccessModes;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface AtomicTraits {
    public static final int SINGLE_ATOMIC = 1;
    public static final int SINGLE_OPAQUE = 3;
    public static final int SINGLE_ACQUIRE = 7;
    public static final int SINGLE_RELEASE = 11;
    public static final int SINGLE_ACQ_REL = 15;
    public static final int SINGLE_SEQ_CST = 31;
    public static final int GLOBAL = 32;
    public static final int GLOBAL_ATOMIC = 33;
    public static final int GLOBAL_LOAD_LOAD = 96;
    public static final int GLOBAL_LOAD_STORE = 160;
    public static final int GLOBAL_STORE_STORE = 288;
    public static final int GLOBAL_STORE_LOAD = 544;
    public static final int GLOBAL_ACQUIRE = 231;
    public static final int GLOBAL_RELEASE = 427;
    public static final int GLOBAL_ACQ_REL = 495;
    public static final int GLOBAL_SEQ_CST = 1023;

    public int getBits();

    public static boolean matches(int bits, int test) {
        return (bits & test) == bits;
    }

    public static AccessMode fromBits(int bits) {
        if (AtomicTraits.matches(bits, 0)) {
            return AccessModes.SingleUnshared;
        }
        if (AtomicTraits.matches(bits, 1)) {
            return AccessModes.SinglePlain;
        }
        if (AtomicTraits.matches(bits, 3)) {
            return AccessModes.SingleOpaque;
        }
        if (AtomicTraits.matches(bits, 7)) {
            return AccessModes.SingleAcquire;
        }
        if (AtomicTraits.matches(bits, 11)) {
            return AccessModes.SingleRelease;
        }
        if (AtomicTraits.matches(bits, 15)) {
            return AccessModes.SingleAcqRel;
        }
        if (AtomicTraits.matches(bits, 31)) {
            return AccessModes.SingleSeqCst;
        }
        if (AtomicTraits.matches(bits, 32)) {
            return AccessModes.GlobalUnshared;
        }
        if (AtomicTraits.matches(bits, 33)) {
            return AccessModes.GlobalPlain;
        }
        if (AtomicTraits.matches(bits, 96)) {
            return AccessModes.GlobalLoadLoad;
        }
        if (AtomicTraits.matches(bits, 160)) {
            return AccessModes.GlobalLoadStore;
        }
        if (AtomicTraits.matches(bits, 288)) {
            return AccessModes.GlobalStoreStore;
        }
        if (AtomicTraits.matches(bits, 544)) {
            return AccessModes.GlobalStoreLoad;
        }
        if (AtomicTraits.matches(bits, 231)) {
            return AccessModes.GlobalAcquire;
        }
        if (AtomicTraits.matches(bits, 427)) {
            return AccessModes.GlobalRelease;
        }
        if (AtomicTraits.matches(bits, 495)) {
            return AccessModes.GlobalAcqRel;
        }
        if (AtomicTraits.matches(bits, 1023)) {
            return AccessModes.GlobalSeqCst;
        }
        throw new IllegalArgumentException("Invalid access mode");
    }
}

