/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.type.ArrayType;

public final class ArrayLiteral
extends Literal {
    private final List<Literal> values;
    private final ArrayType type;
    private final int hashCode;

    ArrayLiteral(ArrayType type, List<Literal> values) {
        this.values = values;
        this.type = type;
        this.hashCode = Objects.hash(type, values);
    }

    public List<Literal> getValues() {
        return this.values;
    }

    @Override
    public ArrayType getType() {
        return this.type;
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public Value extractElement(LiteralFactory lf, Value index) {
        IntegerLiteral il;
        int realIndex;
        if (index instanceof IntegerLiteral && 0 <= (realIndex = (il = (IntegerLiteral)index).intValue()) && realIndex < this.values.size()) {
            return this.values.get(realIndex);
        }
        return null;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof ArrayLiteral && this.equals((ArrayLiteral)other);
    }

    public boolean equals(ArrayLiteral other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.values.equals(other.values) && this.type.equals(other.type);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public StringBuilder toString(StringBuilder target) {
        target.append('[');
        Iterator<Literal> iterator = this.values.iterator();
        if (iterator.hasNext()) {
            target.append(iterator.next());
            while (iterator.hasNext()) {
                target.append(',');
                target.append(iterator.next());
            }
        }
        target.append(']');
        return target;
    }
}

