/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import java.util.Objects;
import java.util.Set;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.type.FunctionType;
import org.qbicc.type.PointerType;

public final class AsmLiteral
extends Literal {
    private final String instruction;
    private final String constraints;
    private final Set<Flag> flags;
    private final FunctionType type;
    private final int hashCode;

    AsmLiteral(String instruction, String constraints, Set<Flag> flags, FunctionType type) {
        this.instruction = instruction;
        this.constraints = constraints;
        this.flags = flags;
        this.type = type;
        this.hashCode = Objects.hash(instruction, constraints, flags, type);
    }

    @Override
    public boolean equals(Literal obj) {
        AsmLiteral other;
        return obj instanceof AsmLiteral && this.equals(other = (AsmLiteral)obj);
    }

    public boolean equals(AsmLiteral other) {
        return this == other || other != null && this.instruction.equals(other.instruction) && this.constraints.equals(other.constraints) && this.flags.equals(other.flags) && this.type.equals(other.type);
    }

    public boolean hasFlag(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getConstraints() {
        return this.constraints;
    }

    @Override
    public boolean isNoThrow() {
        return this.flags.contains((Object)Flag.NO_THROW);
    }

    @Override
    public boolean isNoReturn() {
        return this.flags.contains((Object)Flag.NO_RETURN);
    }

    @Override
    public boolean isNoSideEffect() {
        return !this.flags.contains((Object)Flag.SIDE_EFFECT) && !this.flags.contains((Object)Flag.IMPLICIT_SIDE_EFFECT);
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.type.toString(b.append("asm \"").append(this.instruction).append("\", \"").append(this.constraints).append("\" as "));
    }

    @Override
    public FunctionType getPointeeType() {
        return this.type;
    }

    @Override
    public PointerType getType() {
        return this.type.getPointer();
    }

    @Override
    public AccessMode getDetectedMode() {
        return AccessModes.SingleUnshared;
    }

    public static enum Flag {
        INTEL_DIALECT,
        ALIGN_STACK,
        SIDE_EFFECT,
        IMPLICIT_SIDE_EFFECT,
        NO_THROW,
        NO_RETURN;

    }
}

