/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.graph.literal.WordLiteral;
import org.qbicc.type.BooleanType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.WordType;

public final class BooleanLiteral
extends WordLiteral {
    private final BooleanType type;
    private final boolean value;

    BooleanLiteral(BooleanType type, boolean value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public BooleanType getType() {
        return this.type;
    }

    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public boolean isZero() {
        return !this.value;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof BooleanLiteral && this.equals((BooleanLiteral)other);
    }

    public boolean equals(BooleanLiteral other) {
        return this == other || other != null && this.value == other.value && this.type.equals(other.type);
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    Literal convert(LiteralFactory lf, WordType toType) {
        if (toType instanceof IntegerType) {
            return lf.literalOf((IntegerType)toType, this.value ? 1L : 0L);
        }
        return super.convert(lf, toType);
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return b.append(this.value);
    }

    @Override
    public boolean isDefEq(Value other) {
        return this.equals(other);
    }

    @Override
    public boolean isDefNe(Value other) {
        return other instanceof BooleanLiteral && !this.equals((BooleanLiteral)other);
    }
}

