/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.type.ArrayType;
import org.qbicc.type.PointerType;
import org.qbicc.type.WordType;

public class ElementOfLiteral
extends Literal {
    final Literal arrayPointer;
    final Literal index;

    ElementOfLiteral(Literal arrayPointer, Literal index) {
        this.arrayPointer = arrayPointer;
        this.index = index;
    }

    @Override
    public int getValueDependencyCount() {
        return 2;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> this.arrayPointer;
            case 1 -> this.index;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof ElementOfLiteral && this.equals((ElementOfLiteral)other);
    }

    public boolean equals(ElementOfLiteral other) {
        return other == this || other != null && this.arrayPointer.equals(other.arrayPointer) && this.index.equals(other.index);
    }

    @Override
    public int hashCode() {
        return this.arrayPointer.hashCode() * 19 + this.index.hashCode();
    }

    @Override
    public PointerType getType() {
        return this.arrayPointer.getPointeeType(ArrayType.class).getElementType().getPointer();
    }

    public Literal getArrayPointer() {
        return this.arrayPointer;
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    public Literal getIndex() {
        return this.index;
    }

    @Override
    Literal bitCast(LiteralFactory lf, WordType toType) {
        if (toType.equals(this.arrayPointer.getType()) && this.index.isZero()) {
            return this.arrayPointer;
        }
        return super.bitCast(lf, toType);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        b.append("element_of").append('(');
        this.arrayPointer.toString(b);
        b.append(',');
        this.index.toString(b);
        b.append(')');
        return b;
    }
}

