/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.graph.literal.WordLiteral;
import org.qbicc.type.BooleanType;
import org.qbicc.type.FloatType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.WordType;

public final class IntegerLiteral
extends WordLiteral {
    private final long value;
    private final IntegerType type;
    private final int hashCode;

    IntegerLiteral(IntegerType type, long value) {
        this.value = type.truncateValue(value);
        this.type = type;
        this.hashCode = Long.hashCode(value) * 19 + type.hashCode();
    }

    @Override
    public IntegerType getType() {
        return this.type;
    }

    public long longValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public char charValue() {
        return (char)this.value;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof IntegerLiteral && this.equals((IntegerLiteral)other);
    }

    public boolean equals(IntegerLiteral other) {
        return this == other || other != null && this.value == other.value && this.type.equals(other.type);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    Literal bitCast(LiteralFactory lf, WordType toType) {
        int minBits = this.type.getMinBits();
        if (toType.getMinBits() != minBits) {
            throw new IllegalArgumentException("Invalid literal bitcast between differently-sized types");
        }
        if (toType instanceof IntegerType) {
            return lf.literalOf((IntegerType)toType, this.value);
        }
        if (toType instanceof FloatType) {
            return lf.literalOf((FloatType)toType, minBits == 32 ? (double)Float.intBitsToFloat(this.intValue()) : Double.longBitsToDouble(this.longValue()));
        }
        if (toType instanceof NullableType && this.value == 0L) {
            return lf.nullLiteralOfType((NullableType)toType);
        }
        return super.bitCast(lf, toType);
    }

    @Override
    Literal convert(LiteralFactory lf, WordType toType) {
        IntegerType it;
        if (toType instanceof FloatType) {
            if (this.type instanceof UnsignedIntegerType && this.type.getMinBits() == 64) {
                return lf.literalOf((FloatType)toType, (double)(this.value >>> 1) * 2.0);
            }
            return lf.literalOf((FloatType)toType, (double)this.value);
        }
        if (toType instanceof BooleanType) {
            return lf.literalOf((this.value & 1L) != 0L);
        }
        if (toType instanceof IntegerType && (it = (IntegerType)toType).getSize() == this.type.getSize()) {
            return this.bitCast(lf, toType);
        }
        return super.convert(lf, toType);
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public String toString() {
        return this.type.toString(this);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        b.append(this.type.toString(this));
        return b;
    }

    @Override
    public boolean isZero() {
        return this.value == 0L;
    }

    @Override
    public boolean isDefEq(Value other) {
        return this.equals(other);
    }

    @Override
    public boolean isDefNe(Value other) {
        return other instanceof IntegerLiteral && !this.equals((IntegerLiteral)other);
    }

    @Override
    public boolean isDefLt(Value other) {
        return other instanceof IntegerLiteral && this.isDefLt((IntegerLiteral)other);
    }

    public boolean isDefLt(IntegerLiteral other) {
        IntegerType type = this.type;
        return type.equals(other.type) && (type instanceof SignedIntegerType ? this.value < other.value : Long.compareUnsigned(this.value, other.value) < 0);
    }

    @Override
    public boolean isDefGt(Value other) {
        return other instanceof IntegerLiteral && this.isDefGt((IntegerLiteral)other);
    }

    public boolean isDefGt(IntegerLiteral other) {
        IntegerType type = this.type;
        return type.equals(other.type) && (type instanceof SignedIntegerType ? this.value > other.value : Long.compareUnsigned(this.value, other.value) > 0);
    }

    @Override
    public boolean isDefLe(Value other) {
        return other instanceof IntegerLiteral && this.isDefLe((IntegerLiteral)other);
    }

    public boolean isDefLe(IntegerLiteral other) {
        IntegerType type = this.type;
        return type.equals(other.type) && (type instanceof SignedIntegerType ? this.value <= other.value : Long.compareUnsigned(this.value, other.value) <= 0);
    }

    @Override
    public boolean isDefGe(Value other) {
        return other instanceof IntegerLiteral && this.isDefGe((IntegerLiteral)other);
    }

    public boolean isDefGe(IntegerLiteral other) {
        IntegerType type = this.type;
        return type.equals(other.type) && (type instanceof SignedIntegerType ? this.value >= other.value : Long.compareUnsigned(this.value, other.value) >= 0);
    }
}

