/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import java.util.Arrays;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.type.ArrayType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.ValueType;

public final class ShortArrayLiteral
extends Literal {
    private final short[] values;
    private final ArrayType type;
    private final int hashCode;

    ShortArrayLiteral(ArrayType type, short[] values) {
        this.values = values;
        this.type = type;
        type.getElementType(IntegerType.class);
        this.hashCode = type.hashCode() * 19 + Arrays.hashCode(values);
    }

    public short[] getValues() {
        return this.values;
    }

    @Override
    public ArrayType getType() {
        return this.type;
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public Value extractElement(LiteralFactory lf, Value index) {
        IntegerLiteral il;
        int realIndex;
        if (index instanceof IntegerLiteral && 0 <= (realIndex = (il = (IntegerLiteral)index).intValue()) && realIndex < this.values.length) {
            short realVal = this.values[realIndex];
            ValueType valueType = this.type.getElementType();
            if (valueType instanceof IntegerType) {
                IntegerType it = (IntegerType)valueType;
                if (it instanceof SignedIntegerType) {
                    return new IntegerLiteral(it, realVal);
                }
                return new IntegerLiteral(it, Short.toUnsignedInt(realVal));
            }
        }
        return null;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof ShortArrayLiteral && this.equals((ShortArrayLiteral)other);
    }

    public boolean equals(ShortArrayLiteral other) {
        return this == other || other != null && this.hashCode == other.hashCode && Arrays.equals(this.values, other.values) && this.type.equals(other.type);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public StringBuilder toString(StringBuilder target) {
        target.append('[');
        if (this.values.length > 0) {
            target.append(Integer.toHexString(Short.toUnsignedInt(this.values[0])));
            for (int i = 1; i < this.values.length; ++i) {
                target.append(',');
                target.append(Integer.toHexString(Short.toUnsignedInt(this.values[i])));
            }
        }
        target.append(']');
        return target;
    }
}

