/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.literal.Literal;
import org.qbicc.type.PointerType;
import org.qbicc.type.definition.element.VariableElement;

public abstract class VariableLiteral
extends Literal {
    private final VariableElement variable;

    VariableLiteral(VariableElement variable) {
        this.variable = variable;
    }

    public VariableElement getVariableElement() {
        return this.variable;
    }

    @Override
    public PointerType getType() {
        return this.variable.getType().getPointer();
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return this.toReferenceString(b);
    }

    @Override
    public int hashCode() {
        return this.variable.hashCode();
    }

    @Override
    public AccessMode getDetectedMode() {
        if (this.variable.hasAllModifiersOf(64)) {
            return AccessModes.GlobalSeqCst;
        }
        return AccessModes.SingleUnshared;
    }

    @Override
    public final boolean equals(Literal other) {
        VariableLiteral vl;
        return other instanceof VariableLiteral && this.equals(vl = (VariableLiteral)other);
    }

    public boolean equals(VariableLiteral other) {
        return this == other || other != null && this.variable.equals(other.variable);
    }
}

