/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph.literal;

import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.type.ArrayType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.ValueType;

public final class ZeroInitializerLiteral
extends Literal {
    private final ValueType type;

    ZeroInitializerLiteral(ValueType type) {
        this.type = type;
    }

    @Override
    public ValueType getType() {
        return this.type;
    }

    @Override
    public boolean isZero() {
        return true;
    }

    @Override
    public boolean equals(Literal other) {
        return other instanceof ZeroInitializerLiteral && this.equals((ZeroInitializerLiteral)other);
    }

    public boolean equals(ZeroInitializerLiteral other) {
        return other == this || other != null && this.type.equals(other.type);
    }

    @Override
    public <T, R> R accept(LiteralVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public Value extractElement(LiteralFactory lf, Value index) {
        ValueType valueType = this.type;
        if (valueType instanceof ArrayType) {
            ArrayType at = (ArrayType)valueType;
            return lf.zeroInitializerLiteralOfType(at.getElementType());
        }
        return null;
    }

    @Override
    public Value extractMember(LiteralFactory lf, CompoundType.Member member) {
        if (this.type instanceof CompoundType) {
            return lf.zeroInitializerLiteralOfType(member.getType());
        }
        return null;
    }

    @Override
    public int hashCode() {
        return ZeroInitializerLiteral.class.hashCode();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        b.append('(');
        this.type.toString(b);
        b.append(')');
        b.append("{0}");
        return b;
    }
}

