/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.interpreter;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Consumer;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.literal.Literal;
import org.qbicc.interpreter.Memory;
import org.qbicc.interpreter.Signal;
import org.qbicc.interpreter.Thrown;
import org.qbicc.interpreter.VmArray;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.interpreter.VmInvokable;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmPrimitiveClass;
import org.qbicc.interpreter.VmPrivate;
import org.qbicc.interpreter.VmReferenceArray;
import org.qbicc.interpreter.VmString;
import org.qbicc.interpreter.VmThread;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.Primitive;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.GlobalVariableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.methodhandle.MethodHandleConstant;

public interface Vm {
    public CompilationContext getCompilationContext();

    public void initialize();

    public void initialize2();

    public VmThread newThread(String var1, VmObject var2, boolean var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void doAttached(VmThread thread, Runnable action) {
        Assert.checkNotNullParam((String)"thread", (Object)thread);
        Assert.checkNotNullParam((String)"action", (Object)action);
        VmThread old = VmPrivate.CURRENT_THREAD.get();
        VmPrivate.CURRENT_THREAD.set(thread);
        try {
            action.run();
        }
        finally {
            if (old == null) {
                VmPrivate.CURRENT_THREAD.remove();
            } else {
                VmPrivate.CURRENT_THREAD.set(old);
            }
        }
    }

    public static VmThread currentThread() {
        return VmPrivate.CURRENT_THREAD.get();
    }

    public static VmThread requireCurrentThread() {
        VmThread vmThread = Vm.currentThread();
        if (vmThread == null) {
            throw new IllegalStateException("Thread is not attached");
        }
        return vmThread;
    }

    public static Vm current() {
        return Vm.requireCurrentThread().getVM();
    }

    public static Vm requireCurrent() {
        Vm current = Vm.current();
        if (current == null) {
            throw new IllegalStateException("JavaVM is not attached");
        }
        return current;
    }

    public DefinedTypeDefinition loadClass(ClassContext var1, String var2) throws Thrown;

    public byte[] loadResource(ClassContext var1, String var2) throws Thrown;

    public List<byte[]> loadResources(ClassContext var1, String var2) throws Thrown;

    public VmObject allocateObject(ClassObjectType var1);

    public void invokeExact(ConstructorElement var1, VmObject var2, List<Object> var3);

    public Object invokeExact(MethodElement var1, VmObject var2, List<Object> var3);

    public void initialize(VmClass var1);

    public Object invokeVirtual(MethodElement var1, VmObject var2, List<Object> var3);

    public VmObject newInstance(VmClass var1, ConstructorElement var2, List<Object> var3) throws Thrown;

    public void deliverSignal(Signal var1);

    public VmObject allocateDirectBuffer(ByteBuffer var1);

    public DefinedTypeDefinition.Builder newTypeDefinitionBuilder(VmClassLoader var1);

    public VmObject getMainThreadGroup();

    public Memory allocate(ValueType var1, long var2);

    public VmClass getClassForDescriptor(VmClassLoader var1, TypeDescriptor var2);

    public VmString intern(String var1);

    public boolean isInternedString(VmObject var1);

    public void forEachInternedString(Consumer<VmString> var1);

    public VmClassLoader getClassLoaderForContext(ClassContext var1);

    public void registerInvokable(ExecutableElement var1, VmInvokable var2);

    public void registerHooks(VmClass var1, Class<?> var2, MethodHandles.Lookup var3) throws IllegalArgumentException;

    default public void registerHooks(VmClass clazz, Class<?> hookClass) throws IllegalArgumentException {
        this.registerHooks(clazz, hookClass, MethodHandles.publicLookup());
    }

    public VmPrimitiveClass getPrimitiveClass(Primitive var1);

    public VmObject createMethodType(ClassContext var1, MethodDescriptor var2);

    public VmObject createMethodType(ExecutableElement var1);

    public VmObject createMethodHandle(ClassContext var1, VmClass var2, MethodHandleConstant var3) throws Thrown;

    public VmObject box(ClassContext var1, Literal var2);

    public VmReferenceArray newArrayOf(VmClass var1, int var2);

    public VmReferenceArray newArrayOf(VmClass var1, VmObject[] var2);

    public VmArray newByteArray(byte[] var1);

    public VmArray newCharArray(char[] var1);

    public VmArray newDoubleArray(double[] var1);

    public VmArray newFloatArray(float[] var1);

    public VmArray newIntArray(int[] var1);

    public VmArray newLongArray(long[] var1);

    public VmArray newShortArray(short[] var1);

    public VmArray newBooleanArray(boolean[] var1);

    public VmObject getLookup(VmClass var1);

    public VmThread[] getStartedThreads();

    public Memory getGlobal(GlobalVariableElement var1);

    public VmClassLoader getAppClassLoader();

    public VmClassLoader getPlatformClassLoader();
}

