/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.object;

import org.qbicc.graph.Value;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.SectionObject;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.MemberElement;

public final class Data
extends SectionObject {
    private final Value value;
    private volatile DataDeclaration declaration;
    private volatile boolean dsoLocal;
    private volatile boolean constant;
    private volatile long offset;

    Data(MemberElement originalElement, ModuleSection moduleSection, String name, ValueType valueType, Value value) {
        super(originalElement, name, valueType, moduleSection);
        this.value = value;
        this.offset = -1L;
    }

    @Override
    public MemberElement getOriginalElement() {
        return super.getOriginalElement();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Value getValue() {
        return this.value;
    }

    public long getOffset() {
        long offset = this.offset;
        if (offset == -1L) {
            throw new IllegalArgumentException("Offset unknown");
        }
        return offset;
    }

    void initOffset(long offset) {
        this.offset = offset;
    }

    public long getSize() {
        return this.value.getType().getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataDeclaration getDeclaration() {
        DataDeclaration declaration = this.declaration;
        if (declaration == null) {
            Data data = this;
            synchronized (data) {
                declaration = this.declaration;
                if (declaration == null) {
                    declaration = this.declaration = new DataDeclaration(this);
                }
            }
        }
        return declaration;
    }

    void initDeclaration(DataDeclaration decl) {
        this.declaration = decl;
    }

    public void setDsoLocal() {
        this.dsoLocal = true;
    }

    public boolean isDsoLocal() {
        return this.dsoLocal;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }
}

