/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.object;

import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.SectionObject;
import org.qbicc.type.FunctionType;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.element.ExecutableElement;

public final class Function
extends SectionObject {
    public static final int FN_NO_RETURN = 1;
    public static final int FN_NO_SIDE_EFFECTS = 2;
    public static final int FN_NO_SAFEPOINTS = 4;
    public static final int FN_NO_THROW = 8;
    private final int fnFlags;
    private volatile MethodBody body;
    private volatile FunctionDeclaration declaration;

    Function(ExecutableElement originalElement, ModuleSection moduleSection, String name, FunctionType functionType, int fnFlags) {
        super(originalElement, name, functionType, moduleSection);
        this.fnFlags = fnFlags;
    }

    @Override
    public ExecutableElement getOriginalElement() {
        return (ExecutableElement)super.getOriginalElement();
    }

    @Override
    public FunctionType getValueType() {
        return (FunctionType)super.getValueType();
    }

    public MethodBody getBody() {
        return this.body;
    }

    public void replaceBody(MethodBody body) {
        this.body = body;
    }

    public int getFlags() {
        return this.fnFlags;
    }

    public boolean isNoReturn() {
        return (this.fnFlags & 1) != 0;
    }

    public boolean isNoSideEffects() {
        return (this.fnFlags & 2) != 0;
    }

    public boolean isNoSafePoints() {
        return (this.fnFlags & 4) != 0;
    }

    public boolean isNoThrow() {
        return (this.fnFlags & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionDeclaration getDeclaration() {
        FunctionDeclaration declaration = this.declaration;
        if (declaration == null) {
            Function function = this;
            synchronized (function) {
                declaration = this.declaration;
                if (declaration == null) {
                    declaration = this.declaration = new FunctionDeclaration(this);
                }
            }
        }
        return declaration;
    }

    void initDeclaration(FunctionDeclaration decl) {
        this.declaration = decl;
    }

    public static int getFunctionFlags(ExecutableElement element) {
        int flags = 0;
        if (element.hasAllModifiersOf(0x400000)) {
            flags |= 2;
        } else if (element.hasAllModifiersOf(0x2000000)) {
            flags |= 1;
        } else if (element.hasAllModifiersOf(131072)) {
            flags |= 4;
        } else if (element.hasAllModifiersOf(0x4000000)) {
            flags |= 8;
        }
        return flags;
    }
}

