/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.object;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.object.Data;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.Declaration;
import org.qbicc.object.Function;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.GlobalXtor;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.ProgramObject;
import org.qbicc.object.Section;
import org.qbicc.type.FunctionType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.MemberElement;

public final class ProgramModule {
    final DefinedTypeDefinition typeDefinition;
    final TypeSystem typeSystem;
    final LiteralFactory literalFactory;
    final Map<String, ProgramObject> moduleObjects = new HashMap<String, ProgramObject>();
    final List<Function> functions = new ArrayList<Function>();
    final Map<Section, ModuleSection> sections = new ConcurrentHashMap<Section, ModuleSection>();
    final List<GlobalXtor> ctors = new ArrayList<GlobalXtor>();
    final List<GlobalXtor> dtors = new ArrayList<GlobalXtor>();

    public ProgramModule(DefinedTypeDefinition typeDefinition, TypeSystem typeSystem, LiteralFactory literalFactory) {
        this.typeDefinition = (DefinedTypeDefinition)Assert.checkNotNullParam((String)"typeDefinition", (Object)typeDefinition);
        this.typeSystem = (TypeSystem)Assert.checkNotNullParam((String)"typeSystem", (Object)typeSystem);
        this.literalFactory = (LiteralFactory)Assert.checkNotNullParam((String)"literalFactory", (Object)literalFactory);
    }

    public DefinedTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public Collection<ModuleSection> sections() {
        ModuleSection[] array = (ModuleSection[])this.sections.values().toArray(ModuleSection[]::new);
        Arrays.sort(array, Comparator.comparing(ProgramObject::getName));
        return List.of(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlobalXtor> constructors() {
        List<GlobalXtor> list = this.ctors;
        synchronized (list) {
            return List.copyOf(this.ctors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlobalXtor> destructors() {
        List<GlobalXtor> list = this.dtors;
        synchronized (list) {
            return List.copyOf(this.dtors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalXtor addConstructor(Function fn, int priority) {
        Assert.checkNotNullParam((String)"fn", (Object)fn);
        Assert.checkMinimumParameter((String)"priority", (int)0, (int)priority);
        GlobalXtor xtor = new GlobalXtor(GlobalXtor.Kind.CTOR, fn, priority);
        List<GlobalXtor> list = this.ctors;
        synchronized (list) {
            this.ctors.add(xtor);
        }
        return xtor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalXtor addDestructor(Function fn, int priority) {
        Assert.checkNotNullParam((String)"fn", (Object)fn);
        Assert.checkMinimumParameter((String)"priority", (int)0, (int)priority);
        GlobalXtor xtor = new GlobalXtor(GlobalXtor.Kind.DTOR, fn, priority);
        List<GlobalXtor> list = this.dtors;
        synchronized (list) {
            this.dtors.add(xtor);
        }
        return xtor;
    }

    public ModuleSection inSection(Section section) {
        return this.sections.computeIfAbsent((Section)Assert.checkNotNullParam((String)"section", (Object)section), this::registerSection);
    }

    public FunctionDeclaration declareFunction(ProgramObject original) {
        if (original instanceof Function) {
            Function fn = (Function)original;
            return this.declareFunction(fn);
        }
        if (original instanceof FunctionDeclaration) {
            FunctionDeclaration decl = (FunctionDeclaration)original;
            return this.declareFunction(decl);
        }
        throw new IllegalArgumentException("Invalid input type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionDeclaration declareFunction(Function originalFunction) {
        Assert.checkNotNullParam((String)"originalFunction", (Object)originalFunction);
        String name = originalFunction.getName();
        Map<String, ProgramObject> definedObjects = this.moduleObjects;
        ProgramModule programModule = this;
        synchronized (programModule) {
            ProgramObject existing = definedObjects.get(name);
            FunctionDeclaration origDecl = originalFunction.getDeclaration();
            if (existing == null) {
                definedObjects.put(name, origDecl);
                return origDecl;
            }
            if (existing == origDecl) {
                return origDecl;
            }
            if (existing instanceof FunctionDeclaration) {
                FunctionDeclaration decl = (FunctionDeclaration)existing;
                if (!originalFunction.getSymbolType().equals(decl.getSymbolType())) {
                    this.clash(originalFunction.getOriginalElement(), name);
                    return origDecl;
                }
                return decl;
            }
            if (existing instanceof Function) {
                Function fn = (Function)existing;
                if (!originalFunction.getSymbolType().equals(fn.getSymbolType())) {
                    this.clash(originalFunction.getOriginalElement(), name);
                    return origDecl;
                }
                return fn.getDeclaration();
            }
            this.clash(originalFunction.getOriginalElement(), name);
            return origDecl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionDeclaration declareFunction(FunctionDeclaration originalDecl) {
        Assert.checkNotNullParam((String)"originalDecl", (Object)originalDecl);
        String name = originalDecl.getName();
        Map<String, ProgramObject> definedObjects = this.moduleObjects;
        ProgramModule programModule = this;
        synchronized (programModule) {
            ProgramObject existing = definedObjects.get(name);
            if (existing == null) {
                definedObjects.put(name, originalDecl);
                return originalDecl;
            }
            if (existing == originalDecl) {
                return originalDecl;
            }
            if (existing instanceof FunctionDeclaration) {
                FunctionDeclaration decl = (FunctionDeclaration)existing;
                if (!originalDecl.getSymbolType().equals(decl.getSymbolType())) {
                    this.clash(originalDecl.getOriginalElement(), name);
                    return originalDecl;
                }
                return decl;
            }
            if (existing instanceof Function) {
                Function fn = (Function)existing;
                if (!originalDecl.getSymbolType().equals(fn.getSymbolType())) {
                    this.clash(originalDecl.getOriginalElement(), name);
                    return originalDecl.getDeclaration();
                }
                return fn.getDeclaration();
            }
            this.clash(originalDecl.getOriginalElement(), name);
            return originalDecl;
        }
    }

    public FunctionDeclaration declareFunction(ExecutableElement originalElement, String name, FunctionType type) {
        return this.declareFunction(originalElement, name, type, originalElement == null ? 0 : Function.getFunctionFlags(originalElement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionDeclaration declareFunction(ExecutableElement originalElement, String name, FunctionType type, int flags) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Map<String, ProgramObject> definedObjects = this.moduleObjects;
        ProgramModule programModule = this;
        synchronized (programModule) {
            ProgramObject existing = definedObjects.get(name);
            if (existing == null) {
                FunctionDeclaration decl = new FunctionDeclaration(originalElement, this, name, type, flags);
                definedObjects.put(name, decl);
                return decl;
            }
            if (existing instanceof FunctionDeclaration) {
                FunctionDeclaration decl = (FunctionDeclaration)existing;
                if (!type.equals(decl.getValueType())) {
                    this.clash(originalElement, name);
                    return new FunctionDeclaration(originalElement, this, name, type, flags);
                }
                return decl;
            }
            if (existing instanceof Function) {
                Function fn = (Function)existing;
                if (!type.equals(fn.getValueType())) {
                    this.clash(originalElement, name);
                    return new FunctionDeclaration(originalElement, this, name, type, flags);
                }
                return fn.getDeclaration();
            }
            this.clash(originalElement, name);
            return new FunctionDeclaration(originalElement, this, name, type, flags);
        }
    }

    public DataDeclaration declareData(ProgramObject original) {
        if (original instanceof Data) {
            Data data = (Data)original;
            return this.declareData(data);
        }
        if (original instanceof DataDeclaration) {
            DataDeclaration decl = (DataDeclaration)original;
            return this.declareData(decl);
        }
        throw new IllegalArgumentException("Invalid input type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataDeclaration declareData(Data originalData) {
        Assert.checkNotNullParam((String)"originalData", (Object)originalData);
        String name = originalData.getName();
        Map<String, ProgramObject> definedObjects = this.moduleObjects;
        ProgramModule programModule = this;
        synchronized (programModule) {
            ProgramObject existing = definedObjects.get(name);
            DataDeclaration origDecl = originalData.getDeclaration();
            if (existing == null) {
                definedObjects.put(name, origDecl);
                return origDecl;
            }
            if (existing == origDecl) {
                return origDecl;
            }
            if (existing instanceof DataDeclaration) {
                DataDeclaration decl = (DataDeclaration)existing;
                if (!originalData.getSymbolType().equals(decl.getSymbolType())) {
                    this.clash(originalData.getOriginalElement(), name);
                    return origDecl;
                }
                return decl;
            }
            if (existing instanceof Data) {
                Data data = (Data)existing;
                if (!originalData.getSymbolType().equals(data.getSymbolType())) {
                    this.clash(originalData.getOriginalElement(), name);
                    return origDecl;
                }
                return data.getDeclaration();
            }
            this.clash(originalData.getOriginalElement(), name);
            return origDecl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataDeclaration declareData(DataDeclaration originalDecl) {
        Assert.checkNotNullParam((String)"originalDecl", (Object)originalDecl);
        String name = originalDecl.getName();
        Map<String, ProgramObject> definedObjects = this.moduleObjects;
        ProgramModule programModule = this;
        synchronized (programModule) {
            ProgramObject existing = definedObjects.get(name);
            if (existing == null) {
                definedObjects.put(name, originalDecl);
                return originalDecl;
            }
            if (existing == originalDecl) {
                return originalDecl;
            }
            if (existing instanceof DataDeclaration) {
                DataDeclaration decl = (DataDeclaration)existing;
                if (!originalDecl.getSymbolType().equals(decl.getSymbolType())) {
                    this.clash(originalDecl.getOriginalElement(), name);
                    return originalDecl;
                }
                return decl;
            }
            if (existing instanceof Data) {
                Data data = (Data)existing;
                if (!originalDecl.getSymbolType().equals(data.getSymbolType())) {
                    this.clash(originalDecl.getOriginalElement(), name);
                    return originalDecl;
                }
                return data.getDeclaration();
            }
            this.clash(originalDecl.getOriginalElement(), name);
            return originalDecl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataDeclaration declareData(MemberElement originalElement, String name, ValueType type) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Map<String, ProgramObject> definedObjects = this.moduleObjects;
        ProgramModule programModule = this;
        synchronized (programModule) {
            ProgramObject existing = definedObjects.get(name);
            if (existing == null) {
                DataDeclaration decl = new DataDeclaration(originalElement, this, name, type);
                definedObjects.put(name, decl);
                return decl;
            }
            if (existing instanceof DataDeclaration) {
                DataDeclaration decl = (DataDeclaration)existing;
                if (!type.equals(decl.getValueType())) {
                    this.clash(originalElement, name);
                }
                return decl;
            }
            if (existing instanceof Data) {
                Data data = (Data)existing;
                if (!type.equals(data.getValueType())) {
                    this.clash(originalElement, name);
                }
                return data.getDeclaration();
            }
            this.clash(originalElement, name);
            return new DataDeclaration(originalElement, this, name, type);
        }
    }

    void clash(MemberElement originalElement, String name) {
        if (originalElement != null) {
            originalElement.getEnclosingType().getContext().getCompilationContext().error((Element)originalElement, "Object '%s' redeclared with different type", name);
        } else {
            this.getTypeDefinition().getContext().getCompilationContext().error("Synthetic object '%s' redeclared with different type", name);
        }
    }

    private ModuleSection registerSection(Section section) {
        return new ModuleSection(section, this.typeSystem.getVoidType(), this);
    }

    public Iterable<Declaration> declarations() {
        return new Iterable<Declaration>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<Declaration> iterator() {
                ArrayList<Declaration> decls;
                ProgramModule programModule = ProgramModule.this;
                synchronized (programModule) {
                    decls = new ArrayList<Declaration>(ProgramModule.this.moduleObjects.size());
                    for (ProgramObject programObject : ProgramModule.this.moduleObjects.values()) {
                        if (!(programObject instanceof Declaration)) continue;
                        Declaration decl = (Declaration)programObject;
                        decls.add(decl);
                    }
                }
                decls.sort(Comparator.comparing(ProgramObject::getName));
                return decls.iterator();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(int fnIndex) {
        ProgramModule programModule = this;
        synchronized (programModule) {
            return this.functions.get(fnIndex);
        }
    }
}

