/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.object;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.Function;
import org.qbicc.object.Declaration;
import org.qbicc.object.Linkage;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.ThreadLocalMode;
import org.qbicc.pointer.ProgramObjectPointer;
import org.qbicc.type.PointerType;
import org.qbicc.type.ValueType;

public abstract class ProgramObject {
    private static final VarHandle pointerHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "pointer", VarHandle.class, ProgramObject.class, ProgramObjectPointer.class);
    final String name;
    final ValueType valueType;
    private final PointerType type;
    volatile Linkage linkage = Linkage.EXTERNAL;
    volatile ThreadLocalMode threadLocalMode;
    volatile ProgramObjectPointer pointer;

    ProgramObject(String name, ValueType valueType) {
        this.name = name;
        this.valueType = valueType;
        this.type = valueType.getPointer();
    }

    ProgramObject(ProgramObject original) {
        this.name = original.getName();
        this.valueType = original.getValueType();
        this.type = original.getSymbolType();
        this.linkage = original.getLinkage();
        this.threadLocalMode = original.getThreadLocalMode();
    }

    public abstract ProgramModule getProgramModule();

    public String getName() {
        return this.name;
    }

    public final PointerType getSymbolType() {
        return this.type;
    }

    public ProgramObjectPointer getPointer() {
        return ProgramObjectPointer.of(this);
    }

    public ProgramObjectPointer getOrCreatePointer(Function<ProgramObject, ProgramObjectPointer> factory) {
        ProgramObjectPointer appearing;
        ProgramObjectPointer pointer = this.pointer;
        if (pointer == null && (appearing = pointerHandle.compareAndExchange(this, null, pointer = factory.apply(this))) != null) {
            pointer = appearing;
        }
        return pointer;
    }

    public abstract Declaration getDeclaration();

    public ValueType getValueType() {
        return this.valueType;
    }

    public <T extends ValueType> T getValueType(Class<T> expected) {
        return (T)((ValueType)expected.cast(this.getValueType()));
    }

    public Linkage getLinkage() {
        return this.linkage;
    }

    public void setLinkage(Linkage linkage) {
        this.linkage = (Linkage)((Object)Assert.checkNotNullParam((String)"linkage", (Object)((Object)linkage)));
    }

    public ThreadLocalMode getThreadLocalMode() {
        return this.threadLocalMode;
    }

    public void setThreadLocalMode(ThreadLocalMode threadLocalMode) {
        this.threadLocalMode = threadLocalMode;
    }
}

