/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.object;

import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.Segment;
import org.qbicc.type.TypeSystem;

public final class Section
implements Comparable<Section> {
    private static final AttachmentKey<ConcurrentMap<String, Section>> KEY = new AttachmentKey();
    private final int index;
    private final String name;
    private final Segment segment;
    private final boolean dataOnly;

    private Section(int index, String name, Segment segment, Attribute ... attributes) {
        this.index = index;
        this.name = name;
        this.segment = segment;
        boolean dataOnly = false;
        for (Attribute attribute : attributes) {
            if (attribute != Flag.DATA_ONLY) continue;
            dataOnly = true;
        }
        this.dataOnly = dataOnly;
    }

    public static Section requireSection(CompilationContext ctxt, String name) {
        Section section = (Section)Section.getMap(ctxt).get(name);
        if (section == null) {
            throw new NoSuchElementException("No section called " + name + " exists");
        }
        return section;
    }

    public static Section defineSection(CompilationContext ctxt, int index, String name, Segment segment, Attribute ... attributes) {
        ConcurrentMap<String, Section> map = Section.getMap(ctxt);
        Section section = (Section)map.get(name);
        if (section == null) {
            section = new Section(index, name, segment, attributes);
            Section appearing = map.putIfAbsent(name, section);
            if (appearing == null) {
                return section;
            }
            section = appearing;
        }
        boolean dataOnly = false;
        for (Attribute attribute : attributes) {
            if (attribute != Flag.DATA_ONLY) continue;
            dataOnly = true;
        }
        if (section.index == index && section.name.equals(name) && section.segment.equals((Object)segment) && section.dataOnly == dataOnly) {
            return section;
        }
        throw new IllegalArgumentException("A section named " + name + " is already defined");
    }

    private static ConcurrentMap<String, Section> getMap(CompilationContext ctxt) {
        ConcurrentMap appearing;
        ConcurrentMap<String, Section> map = ctxt.getAttachment(KEY);
        if (map == null && (appearing = (ConcurrentMap)ctxt.putAttachmentIfAbsent(KEY, map = new ConcurrentHashMap<String, Section>())) != null) {
            return appearing;
        }
        return map;
    }

    @Override
    public int compareTo(Section o) {
        int res = this.segment.compareTo(o.segment);
        if (res == 0) {
            res = Integer.compare(this.index, o.index);
        }
        if (res == 0) {
            res = this.name.compareTo(o.name);
        }
        return res;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public boolean isImplicit() {
        return this.getName().equals("__implicit__");
    }

    public boolean isDataOnly() {
        return this.dataOnly;
    }

    public DataDeclaration getSegmentStartDeclaration(ProgramModule programModule) {
        CompilationContext ctxt = programModule.getTypeDefinition().getContext().getCompilationContext();
        TypeSystem ts = ctxt.getTypeSystem();
        return programModule.declareData(null, ctxt.getPlatform().formatStartOfSectionSymbolName(this.segment.toString(), this.name), ts.getVoidType().getPointer());
    }

    public DataDeclaration getSegmentEndDeclaration(ProgramModule programModule) {
        CompilationContext ctxt = programModule.getTypeDefinition().getContext().getCompilationContext();
        TypeSystem ts = ctxt.getTypeSystem();
        return programModule.declareData(null, ctxt.getPlatform().formatEndOfSectionSymbolName(this.segment.toString(), this.name), ts.getVoidType().getPointer());
    }

    public static final class Flag
    extends Attribute {
        private final String name;
        public static final Flag DATA_ONLY = new Flag("DATA_ONLY");

        private Flag(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            Flag flag;
            return obj instanceof Flag && this.equals(flag = (Flag)obj);
        }

        public boolean equals(Flag other) {
            return this == other;
        }

        public String toString() {
            return this.name;
        }
    }

    public static abstract class Attribute {
        Attribute() {
        }
    }
}

